#include <OS/string.h>
#include <stream.h>
#include <X11/keysym.h>
#include <InterViews/event.h>
#include <InterViews/window.h>
#include "usercom.h"
#include "com_input.h"
#include "dsp_app.h"
#include "xdrv.h"
#include "cgidbg.h"
#include "playback.h"
#include "txtwin.h"



/*
 * static void print_name(ivStyle *s)
 * {
 *	TheLog << "print_name called\n" ;
 *	const osString name("name");
 *	const osString iconName("iconName");
 *	osString temp ;
 *	if (s->find_attribute(name,temp)) LogOut << "name `" << temp.string()
 *		<< "'.\n" ;
 *	if (s->find_attribute(iconName,temp)) LogOut << "iconName `" <<
 *		temp.string() << "'.\n" ;
 *	TheLog << "print_name exit\n" ;
 * }
 */

FocusSelector::FocusSelector():
	prompt_window(0),
	deletable(0),
	current_focus(0),
	the_window_name(0),
	removed_flag(1),
	raise_flag(0)
{
	clear_prompt();
}

DspInputHandler::DspInputHandler(ivGlyph * g, ivStyle * s):
	ivInputHandler(g,s)
{
	// print_name(s);
}

DspActiveHandler::DspActiveHandler(ivGlyph * g, ivStyle * s):
	ivActiveHandler(g,s)
{
	// print_name(s);
}


void FocusSelector::current_keystroke(ivEvent e)
{
	if (current_focus) current_focus->keystroke(e);
}


int FocusSelector::common_keystroke(ivEvent e)
{
	int control = e.control_is_down();
	int shift = e.shift_is_down();
	long sym = e.keysym();
	sym &=0xffffL ;
	if (!DspApplication::user_input_allowed(0)) switch (sym) {
case XK_Shift_L:
case XK_Shift_R:
case XK_Control_L:
case XK_Control_R:
		return 1 ;
case XK_Delete:
		if (!shift && control) {
			ManagedKeyboards::manager()->abort_play();
			return 1 ;
		}
default:
		DspApplication::user_input_allowed(); // give warning
		return 1 ;

	} else switch (sym) {

case XK_6:
		if (shift && control) {
			print_display();
			return 1;
		}
		break ;
case XK_7:
		if (shift && control) {
			print_window();
			return 1;
		}
		break ;
case XK_8:
		if (shift && control) {
			print_window_raise();
			return 1 ;
		}
		break ;
case XK_Delete:
		if (control && shift) {
			// LogOut << "exit window called\n" ;
			exit_window();
			// LogOut << "after exit window called\n" ;
			return 1 ;
		}
		break ;
	}
	return 0 ;
}


void DspInputHandler::keystroke(const ivEvent& e)
{
	if (DspApplication::prompt_active()) return ;
	if (FocusSelector::common_keystroke(e)) return ;
	if (!base_keystroke(e,this)) current_keystroke(e);
}

void FocusSelector::clear_focus()
{
	if (current_focus) {
		current_focus->undraw();
		current_focus->focus_out();
	}
	current_focus = 0 ;
}

void FocusSelector::edit_init()
{
}

void FocusSelector::request_focus(ScrollFieldEditor& editor)
{
	editor.do_init();
	if (!input_allowed(&editor)) {
		editor.focus_out();
		return ;
	}
	if (current_focus == &editor) return ;
	clear_focus();
	current_focus = &editor ;
	editor.focus_in();
	editor.select(0);
	editor.scroll_patch_redraw();
}




void DspActiveHandler::keystroke(const ivEvent& e)
{
	if (FocusSelector::common_keystroke(e)) return ;
	if (!base_keystroke(e,this)) current_keystroke(e);
}





