#ifdef __NT_VC__
#include <stdio.h>
/*****************************************************************************
 *                                                                           *
 * Was DH_DIR.C                                                                  *
 *                                                                           *
 * Freely redistributable and modifiable.  Use at your own risk.             *
 *                                                                           *
 * Copyright 1994 The Downhill Project                                       *
 *                                                                           *
 *****************************************************************************/
/*
dirent.c
Modified by Paul Budnik for GNU Bash and ObjectProDSP
*/
/*****************************************************************************
 *                                                                           *
 * sys/dirent.h                                                              *
 *                                                                           *
 * Freely redistributable and modifiable.  Use at your own risk.             *
 *                                                                           *
 * Copyright 1994 The Downhill Project                                       *
 *                                                                           *
 *****************************************************************************/



/* Include stuff *************************************************************/
#include <stdlib.h>
#include <windows.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <io.h>



/* Struct and typedef stuff **************************************************/

/* Directory entry (file) struct =========================================== */
struct dirent
{
	unsigned long   d_fileno;
	unsigned short  d_namlen;
	char            d_name[_MAX_PATH+1];
};

/* Directory info typedef ================================================== */
typedef struct __dirdesc
{
	char          dir_Name[_MAX_PATH+1];
	HANDLE        dir_Handle;
	int           dir_FileCount;
	struct dirent dir_FileUnix;
} DIR;


/* Prototype stuff **********************************************************/
DIR*           opendir(char* dir_Name);
struct dirent* readdir(DIR* dir_Info);
void           rewinddir(DIR* dir_Info);
int            closedir(DIR* dir_Info);
long           telldir(DIR* dir_Info);
void           seekdir(DIR* dir_Info,long dir_Position);





/* Open a directory ======================================================== */
DIR* opendir(char* dir_Name)
{
	DIR*        dir_Info;
	struct stat dir_Stat;

	/* Make sure directory is actually a directory */
	if (stat(dir_Name,&dir_Stat) != 0)
	{
		errno = ENOENT;
		return NULL;
	}
	if ((dir_Stat.st_mode&_S_IFDIR) == 0)
	{
		errno = ENOTDIR;
		return NULL;
	}

	/* Get some memory */
	dir_Info = (DIR*)calloc(1,sizeof(DIR));
	if (dir_Info == NULL)
	{
		return NULL;
	}

	/* Save some info about the directory */
	strcpy(dir_Info->dir_Name,dir_Name);
	if ((dir_Info->dir_Name[strlen(dir_Info->dir_Name)-1] != '/') &&
	 (dir_Info->dir_Name[strlen(dir_Info->dir_Name)-1] != '\\'))
	{
		strcat(dir_Info->dir_Name,"/");
	}
	strcat(dir_Info->dir_Name,"*");
	dir_Info->dir_Handle = INVALID_HANDLE_VALUE;
	dir_Info->dir_FileCount = 0;

	/* And return the directory info */
	return dir_Info;
}

/* Read the next file in a directory ======================================= */
struct dirent* readdir(DIR* dir_Info)
{
	WIN32_FIND_DATA dir_FileWin;

	/* Get the info about the next file */
	if (dir_Info->dir_FileCount == 0)
	{
		dir_Info->dir_Handle = FindFirstFile(dir_Info->dir_Name,
		 &dir_FileWin);
		if (dir_Info->dir_Handle == INVALID_HANDLE_VALUE)
		{
			return NULL;
		}
	}
	else
	{
		if (!FindNextFile(dir_Info->dir_Handle,&dir_FileWin))
		{
			return NULL;
		}
	}

	/* Dummy up a UNIX file */
	dir_Info->dir_FileUnix.d_fileno = dir_Info->dir_FileCount;
	dir_Info->dir_FileUnix.d_namlen = strlen(dir_FileWin.cFileName);
	strcpy(dir_Info->dir_FileUnix.d_name,dir_FileWin.cFileName);

	/* Bump the number we've read */
	dir_Info->dir_FileCount++;

	/* And return the UNIX file info */
	return &(dir_Info->dir_FileUnix);
}

/* Rewind a directory ====================================================== */
void rewinddir(DIR* dir_Info)
{
	/* Re-set to the beginning */
	dir_Info->dir_Handle = INVALID_HANDLE_VALUE;
	dir_Info->dir_FileCount = 0;
}

/* Close a directory ======================================================= */
int closedir(DIR* dir_Info)
{
	/* Close down the directory */
	if (!FindClose(dir_Info->dir_Handle))
	{
		errno = EBADF;
		return -1;
	}

	/* Free up the memory */
	free(dir_Info);

	/* And return that everything went fine */
	return 0;
}

/* Tell our position in a directory ======================================== */
long telldir(DIR* dir_Info)
{
	/* Return our last position */
	return dir_Info->dir_FileCount;
}

/* Seek to a position in a directory ======================================= */
void seekdir(DIR* dir_Info,long dir_Position)
{
	/* Jump back to the beginning of the file */
	rewinddir(dir_Info);

	/* And read to a specific position */
	while (--dir_Position > 0)
	{
		readdir(dir_Info);
	}
}
/*****************************************************************************
 *                                                                           *
 * DH_MISC.C                                                                 *
 *                                                                           *
 * Freely redistributable and modifiable.  Use at your own risk.             *
 *                                                                           *
 * Copyright 1994 The Downhill Project                                       *
 *                                                                           *
 *****************************************************************************/

/* Global stuff **************************************************************/
int   opterr = 1;
int   optind = 1;
int   optopt;
char* optarg;

/* Get command-line flags ================================================== */
/* This was originally the public domain AT&T getopt().  Mine's [DOWNHILL's] prettier, if
   you ask _me_. */
int getopt(int arg_Count,char* arg_Value[],char flag_List[])
{
	static int opt_Position = 1;
	char*      opt_Flag;

	/* If we're at the end of the list, return */
	if (opt_Position == 1)
	{
		if (optind >= arg_Count)
		{
			return EOF;
		}
		else if (((arg_Value[optind][0] != '-')
		 ) || (arg_Value[optind][1] == '\0'))
		{
			return EOF;
		}
		else if (!strcmp(arg_Value[optind],"--"))
		{
			optind++;
			return EOF;
		}
	}

	/* Get this flag */
	optopt = arg_Value[optind][opt_Position];
	opt_Flag = strchr(flag_List,optopt);
	if ((optopt == ':') || (opt_Flag == NULL))
	{
		fprintf(stderr,"%s: illegal option -- %c\n",
		 arg_Value[0],optopt);
		opt_Position++;
		if (arg_Value[optind][opt_Position] == '\0')
		{
			optind++;
			opt_Position = 1;
		}
		return '?';
	}

	/* Does this flag take an argument? */
	opt_Flag++;
	if (*opt_Flag == ':')
	{
		opt_Position++;
		if (arg_Value[optind][opt_Position] != '\0')
		{
			opt_Position++;
			optarg = &(arg_Value[optind][opt_Position]);
		}
		else if (optind+1 >= arg_Count)
		{
			fprintf(stderr,
			 "%s: option requires an argument -- %c\n",
			 arg_Value[0],optopt);
			opt_Position = 1;
			return '?';
		}
		else
		{
			optind++;
			optarg = arg_Value[optind];
		}
		optind++;
		opt_Position = 1;
	}
	else
	{
		opt_Position++;
		if (arg_Value[optind][opt_Position] == '\0')
		{
			opt_Position = 1;
			optind++;
		}
		optarg = NULL;
	}

	/* Return the character */
	return optopt;
}



#endif /* ifdef __NT_VC__ */
