#include <stream.h>
#include <fstream.h>
#include <string.h>
#include <string.h>
#include <stdlib.h>
#include "linlist.h"
#include "mkstr.h"

const char ** FileToList(const char * FileName)
{
	ifstream InFile(FileName);
	if (!InFile.good()) return 0 ;
	const LineLength = 240 ;
	char Buf[LineLength] ;
	char ** ListOfDirNames= 0 ;
	while (InFile.good()) {
		InFile.get(Buf,LineLength);
		char X ;
		char& Eol = X;
		if (InFile.good()) {
			InFile.get(Eol);
			if (Eol != '\n') {
				cerr << "Warning: bad directory file `" <<
					FileName << "'.\n" ;
				return 0 ;
			}
			ListOfDirNames = (char **)
				AddToList(Concatenate(Buf),
				(void **)ListOfDirNames);
		}
	} 
	return (const char **) ListOfDirNames ;
	
}

int InList(const char * Name, const char ** TheList)
{
	if (TheList) for (const char ** Entry = TheList; *Entry; Entry++)
		if (!strcmp(Name,*Entry)) return 1 ;
	return 0 ;
}

static int compare(const void * a, const void *b)
{
	const char * A = * (const char **) a;
	const char * B = * (const char **) b;
	if (A) if (*A) if (B) if(*B) return strcmp(A, B);
	cerr << "flist.C:compare - bad arguments\n" ;
	exit(1);
	return 0 ; // to avoid compiler warning, never executed
}

void StringSort(const char ** StringList)
{
	qsort((char *) StringList, ListLength((const void **) StringList),
		sizeof(*StringList),compare);
}

void DeleteStringList(const char ** StringList)
{
	if (StringList) while (*StringList) delete (char *) *StringList++ ;
	delete StringList ;
}

