/*  text2.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <stream.h>
#include "stdyac.h"
#include "textfrag.h"
#include "texutil.h"
#include "text.h"
#include "spellfil.h"
#include "cgidbg.h"

void EmbeddedTextOut(TextFragmentList * Text, ostream * Out,
	ConstStringList * EmittedOnce)
{
	TextFragmentListIterator Next(*Text);
	TextFragment * Fragment ;
	int LastLine = -1 ;
	while (Fragment = Next()) {
		const char * String = Fragment->Text ;
		if (IsWhiteSpace(String)) {
			// LogOut<<"White space at " << Fragment->Line << "\n";
			LastLine = -1 ;
			continue ;
		}
		int CheckLine = Fragment->Line ;
/*
 *		LogOut << "CheckLine = " << CheckLine << ", LastLine = " <<
 *			LastLine << "\n" ;
 *		LogOut << "`" << String << "'\n" ;
 */
		if (Fragment->Line < 0) {
			if (EmittedOnce) {
				int AlreadyEmitted = EmittedOnce->
					IsInList(String);
				if (!AlreadyEmitted) EmittedOnce->Append(String);
				EmitEmbeddedReference(String,AlreadyEmitted);
			}
			CheckLine = - CheckLine ;
			if (!EmittedOnce) if (CheckLine!= LastLine) LitQuoteOut(String,Out);
			else LitFillQuoteConcat(String,Out);
		} else {
			AddToSpellFile(Fragment->SpellText);
			// if (IsWhiteSpace(String)) continue ;
			if (CheckLine!= LastLine) LitFillOut(String,Out);
			else LitFillConcat(String,Out) ;
		}
		LastLine = CheckLine ;
	}
}

