/*  intfccomg.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "intfccomg.h"
#include "cgidbg.h"
#include "shared.h"
#include "newaloc.h"
#include "remcom.h"
#include "guistate.h"

GuiInterfaceController InterfaceControl ;

void GuiInterfaceController::InParseBeginWaitRead(ReturnCallBack Call)
{
	int TheId = IncrementCallBackId();
	GetTheCallBacks()->Append(new CallBackEntry(TheId++,Call));
	const IdSize = sizeof(TheId);
	DoCallBackAction Action = ParseReadFileAction ;
	const ActionSize = sizeof(Action);
	const BufSize = IdSize+ActionSize ;
	char Buf[BufSize];
	PacketHeader TheHead(PacketInterfaceControl,CallBackCaseReturn,
		BufSize);
	MoveNBytes(Buf,(char *)TheId,IdSize);
	MoveNBytes(Buf+IdSize,(char *) Action,ActionSize);
	WriteSeg->WritePacket(TheHead,Buf);
}

void InterfaceController::ActionServer(int ReturnId,
	DoCallBackAction Action, int RemSize, const char * Data)
{
/*
 *	LogOut << "InterfaceController::ActionServer(" << ReturnId << ", " <<
 *		Action << ", " << RemSize << ")\n" ;
 */
	switch(Action) {
case ReadyForInitReadState:
		State.ReadyForInitReadState(ReturnId);
		break ;
case ParseReadFileAction:
default :
		DbgError("InterfaceController::ActionServer",
			"bad action");
	}
}



void InterfaceController::ActionNoReturnServer(DoActionNoCallBack Action,
	int RemSize, const char * Data)
{
	switch (Action) {
case DoActionSetSaveFileName:
default:
		DbgError("InterfaceController::ActionNoReturnServer",
			"bad case");
	}
}


void InterfaceController::ReturnServer(int ReturnId,
	ReturnCallBackAction Action, int RemSize, const char * Data)
{
	switch (Action) {
case ParseReadFileReturn:
		DoReturn(ReturnId,RemSize,Data);
		break ;
case InitReadFinished:
default:
		DbgError("InterfaceController::ReturnServer",
			"bad action");
	}
}


