/*  outtokf.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "usercom.h"
#include "outtokf.h"
#include "cgidbg.h"
#include "yacintfc.h"


OutTokFile * OutTokFile::open_tok_file(const char * FileName,
	char * ter, int char_per_line)
{
	filebuf * FileBuf = new filebuf ;
	if (!FileBuf->open(FileName,ios::trunc | ios::out)) {
		State.Error("cannot open file `", FileName, "' to save state");	
		char * msg ;
		SystemErrorMessage(1,&msg);
		HelpOut << msg << "\n" ;
		delete FileBuf ;
		return 0 ;
	}
	ostream * Out = new ostream;
	Out->rdbuf(FileBuf);
	return new OutTokFile(FileName,*FileBuf,*Out,0,ter," ","    ",
		char_per_line);
}

void OutTokFile::delete_tok_file(OutTokFile * fle)
{
	filebuf * FileBuf = fle->FileBuf ;
	ostream * Out = fle->Stream ;
	delete fle ;
	delete FileBuf ;
	delete Out ;
}


OutTokFile::OutTokFile (
	const char * Name, filebuf& Buf, ostream& Out,
	int init, const char *ter, const char *sep,
	const char * inis, int lw, int lh, OutTokens::ReturnOption quit):
		OutTokens(&Out, init, ter, sep, inis, lw, lh, quit)
{
	Stream = &Out ;
	FileBuf = &Buf ;
	FileName = Name ;
}

OutTokFile::~OutTokFile()
{
}

