/*  intfccomd.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "intfccomd.h"
#include "cgidbg.h"
#include "newaloc.h"
#include "yacintfc.h"

DspInterfaceController InterfaceControl ;

void InterfaceController::ActionServer(int Id, DoCallBackAction Action,
	int RemSize, const char * Data)
{
/*
 *	LogOut << "InterfaceController::ActionServer(" << Id << ", "
 *		<< Action << ", " << RemSize << "," << (Data ? Data : "NULL")
 *		<< ")\n" ;
 */
	int OverwriteFlag ;
	int FlagSize ;
	switch (Action) {
case ParseReadFileAction:
		OverwriteFlag;
		FlagSize = sizeof(OverwriteFlag);
		if (RemSize <= FlagSize)
			DbgError("InterfaceController::ActionServer",
			"too small");
		MoveNBytes((char *) &OverwriteFlag, Data, FlagSize);
		State.ReadFile(Data+FlagSize,OverwriteFlag,Id);
		break ;
case ReadyForInitReadState:
default:
		DbgError("InterfaceController::ActionServer","bad action");
	}
}

void InterfaceController::ReturnServer(int Id, ReturnCallBackAction Action,
	int RemSize, const char * Data)
{
/*
 *	LogOut << "InterfaceController::ReturnServer(" << Id << ", "
 *		<< Action << ", " << RemSize << "," << (Data ? Data : "NULL")
 *		<< ")\n" ;
 */
	ReturnCallBack DoCall ;
	switch (Action) {
case InitReadFinished:
		DoCall = TheCallBacks->GetCallBack(Id);
		if (!DoCall) DbgError("InterfaceController::ReturnServer",
			"bad id");
		int Temp;
		if (RemSize != sizeof(int)) DbgError(
			"InterfaceController::ReturnServer", "bad size");
		MoveNBytes((char *) &Temp,Data,RemSize);
		DoCall(Action);
		break ;
case ParseReadFileReturn:
default:
		DbgError("InterfaceController::ReturnServer","bad action");
	}
}

void InterfaceController::ActionNoReturnServer(DoActionNoCallBack Action,
	int RemSize, const char * Data)
{
	switch (Action) {
case DoActionSetSaveFileName:
		State.SaveInit(Data);
		return ;
default:
		DbgError("InterfaceController::ActionNoReturnServer",
			"bad case");
	}
}


