#include <stream.h>
#include <fstream.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProGen/mkstr.h"
#include "ObjProGen/environ.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/readflt.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ReadFloatNodeList = 0 ;
static InteractiveEntity * IntEntReadFloat ;
void ReadFloatNodesInit();
ReadFloat::ReadFloat (const char * Name, const char * FileName):
	Signal(Name, 1, 1, 1, 1, TimingTypeLinear, 
	(ArithType::ArithCapabilities)ArithType::ArithTypeUndefined)
,
	FileName_1(FileName)
{
	if (!ReadFloatNodeList) ReadFloatNodesInit() ;
	ReadFloatNodeList->Append(MakeDeclaredEntity(this, IntEntReadFloat)) ;
	InitArithType(TheArithType);
	NewMenuItem("ReadFloat",GetName());
#line 46 "../readflt.usr"
 
	ctor();
#line 40 "../readflt.cxx"
} // end constructor

ReadFloat::~ReadFloat()
{
	TheMenuServer->DeleteMenuItem("ReadFloat",GetName());
	ReadFloatNodeList->Delete(GetName()) ;
#line 50 "../readflt.usr"
 
	dtor();
#line 50 "../readflt.cxx"
} // end destructor

int ReadFloat::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

ReadFloat * ReadFloatDef;

ErrCode ReadFloat::DoNode(int32 k)
{
#line 67 "../readflt.usr"
 
	return kernel(k);
#line 67 "../readflt.cxx"
} // end kernel code

static UserEntity * MakeReadFloat(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int ReadFloat::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntReadFloat->CppList(Out,Cmd,this);
}

void ReadFloat::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeReadFloat(Out,EntityReqDescribeFull,*IntEntReadFloat, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the disk file");
		Out.NextFillOut("to be read. If no name is specified the node name will be used.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntReadFloat->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		break;
	}
} // end  list entity switch

void ReadFloatNodesInit()
{
	if (ReadFloatNodeList)  return ;

	static StringParam ReadFloatNameParam =
		{"ReadFloat", MakeNewEntityName, 0, LegalEntityName};
	static StringParam ReadFloatFileNameParam = {
		 0, 0, 0};

	static OneParameter ReadFloatParArray[] = {
		{"Name", 0, "node name", 0, 0, &ReadFloatNameParam},
		{"FileName", 0, 
			"ascii file to read",
			0, 0, &ReadFloatFileNameParam},
		{0}
	};

	ReadFloatNodeList = new EntityList;
	IntEntReadFloat = new InteractiveEntity("ReadFloat", ReadFloatNodeList,
		MakeReadFloat, InteractiveNode, "readflt.h",
		0, "Signal");
	IntEntReadFloat->SetParameters(new UserParameters(ReadFloatParArray));
	TheNodes->Append(IntEntReadFloat);
} // end initalization

static UserEntity * MakeReadFloat(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("ReadFloat");
		Out.NextFillOut("reads a file of floating point ascii formatted values");
		Out.NextFillOut("and writes them to a data stream of type `MachWord'.");
		Out.NextFillOut("You can have as many values as you want on each line but there");
		Out.NextFillOut("can only be white space as defined in the");
		Out.NextFillOut("C++ input stream functions between numbers.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		return new ReadFloat(Name, FileName);

	}
	}
	return 0;
}

static InitObj LocalInit(ReadFloatNodesInit, "ReadFloat", "Signal");

