#include "readflt.h"
#include "yacintfc.h"
#include <ctype.h>
#include "mkstr.h"
#include "usercom.h"



void ReadFloat::ctor()
{
	TheInputFile = 0 ;
	exp_name = 0 ;
	delete_name = 0 ;
    DidCheck = 0 ;
	open_f(0);
}

void ReadFloat::open_f(int force_error)
{
	const char * new_name = def_name(GetFileName());
	const char * e_name = TargetNode::open_file(&new_name,TheInputFile,0,force_error);
	if (!TheInputFile) return ;

	if (e_name != new_name) exp_name = Concatenate(e_name);
	else exp_name = 0 ; 

	if (new_name != GetFileName()) new_name = delete_name = Concatenate(new_name);
	FileName_1 = new_name ;
}


void ReadFloat::dtor()
{
	delete TheInputFile ;
	delete delete_name ;
}

ErrCode ReadFloat::kernel(int32 k)
{
	if (State.IsError()) return FatalError ;
	if (!TheInputFile) {
        open_f(1);
        if (State.IsError()) return FatalError ;
    }
	if (!TheInputFile->good()) {
		if (DidCheck) return EndOfData ;
		State.Error("Cannot read file `",GetFileName(),"'");
        expand_name(GetFileName(),exp_name);
        HelpOut << "Error in node `" << GetName() << "'.\n" ;
        return FatalError ;
	}
	DidCheck = 1 ;
	for (int i = 0 ; i < k ; i++) {
		double Temp ;
		*TheInputFile >> Temp ;
		if (TheInputFile->fail()) return EndOfData ;
		MachWord t = Temp ;
		WriteWord(t);
	}
	return OK ;
}
