#include "ObjProNet/dfnode.h"

#include "ObjProUsr/procstr.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
#include "ObjProDSPint/nodmem.h"
static EntityList * ProcessNodeStrNodeList = 0 ;
static InteractiveEntity * IntEntProcessNodeStr ;
void ProcessNodeStrNodesInit();
ProcessNodeStr::ProcessNodeStr (const char * Name, int16 in, int16 out, StreamStr*StreamIn, 
		StreamStr*StreamOut, int32 NodeDelay, int32 DeltaIn, 
		int32 DeltaOut, int32 Overlap, int32 DelayIn, 
		TimingType TheTimingType):
	Node(Name, in, out, StreamIn, StreamOut, NodeDelay, DeltaIn, 
	DeltaOut, Overlap, DelayIn, TheTimingType)
,
	in_1(in),
	out_2(out),
	StreamIn_3(StreamIn),
	StreamOut_4(StreamOut),
	NodeDelay_5(NodeDelay),
	DeltaIn_6(DeltaIn),
	DeltaOut_7(DeltaOut),
	Overlap_8(Overlap),
	DelayIn_9(DelayIn),
	TheTimingType_10(TheTimingType)
{
} // end constructor

ProcessNodeStr::~ProcessNodeStr()
{
} // end destructor

int ProcessNodeStr::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

static ValueType * Raise(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("Raise");
		Out.NextFillOut("will cause a displayed window referencing this node to raised");
		Out.NextFillOut("to the top level over any overlapping windows.");
		Out.NextFillOut("Examples of windows that will be affected are a network display");
		Out.NextFillOut("containing this node or a plot window for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((ProcessNodeStr * )This)->Raise(
		);		}
	}
	return 0;
}

static ValueType * SetSampleRate(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The");
		Out.NextQuoteOut("SetSampleRate");
		Out.NextFillOut("member function sets the sample");
		Out.NextFillOut("rate for the specified output channel of this node.");
		Out.NextFillOut("In turn the rates for all input and output channels connected");
		Out.NextFillOut("to this node are adjusted with one exception.");
		Out.NextFillOut("The adjustment will * b + c");
		Out.NextFillOut("not be made through a node output channel that specifies");
		Out.NextFillOut("a timing relationship of");
		Out.NextFillOut("`TimingTypeRandom'");
		Out.NextFillOutConcat(".");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		double Rate =
			Param->GetFloatParameterValue("Rate");
		int16 Channel =
			Param->GetIntParameterValue("Channel");

		((ProcessNodeStr * )This)->SetSampleRate(
		Rate, Channel);		}
	}
	return 0;
}

static ValueType * DisplayInputTiming(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayInputTiming");
		Out.NextFillOut("displays the timing");
		Out.NextFillOut("of the selected input channel for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Channel =
			Param->GetIntParameterValue("Channel");

		((ProcessNodeStr * )This)->DisplayInputTiming(
		Channel);		}
	}
	return 0;
}

static ValueType * DisplayOutputTiming(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayOutputTiming");
		Out.NextFillOut("displays the timing");
		Out.NextFillOut("of the selected output channel for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Channel =
			Param->GetIntParameterValue("Channel");

		((ProcessNodeStr * )This)->DisplayOutputTiming(
		Channel);		}
	}
	return 0;
}

static ValueType * Edit(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("If this node is not linked in an existing network it will be");
		Out.NextFillOut("added to the display of the network currently being edited. If");
		Out.NextFillOut("there is no such network one will be created.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((ProcessNodeStr * )This)->Edit(
		);		}
	}
	return 0;
}

static ValueType * Unlink(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("Unlink");
		Out.NextFillOut("disconnects this node from the");
		Out.NextFillOut("DSP network it is linked in. All nodes that are connected");
		Out.NextFillOut("as outputs from this node will be unlinked. This process");
		Out.NextFillOut("continues recursively up to the terminal output nodes of all");
		Out.NextFillOut("affected threads. Unlinking the first node in a single");
		Out.NextFillOut("thread network will unlink every node in the network.");
		Out.NextFillOut("If a node has two or more inputs and only one of these is unlinked");
		Out.NextFillOut("the node will remain connected to the network");
		Out.NextFillOut("on the unaffected input channel or channels.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((ProcessNodeStr * )This)->Unlink(
		);		}
	}
	return 0;
}

static ValueType * LinkIn(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The");
		Out.NextQuoteOut("LinkIn");
		Out.NextFillOut("member function selects the");
		Out.NextFillOut("next input channel to link to. It's single parameter (");
		Out.NextFillOutConcat("Channel");
		Out.NextFillOutConcat(")");
		Out.NextFillOut("specifies the channel index. Ordinarily the");
		Out.NextFillOut("first unused channel is linked to. This function");
		Out.NextFillOut("overrides that default.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Channel =
			Param->GetIntParameterValue("Channel");

		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((ProcessNodeStr * )This)->LinkIn(
		Channel));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * NextFreeInput(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("This function displays the next available input link for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((ProcessNodeStr * )This)->NextFreeInput(
		);		}
	}
	return 0;
}

static ValueType * NextFreeOutput(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("This function displays the next available output link for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((ProcessNodeStr * )This)->NextFreeOutput(
		);		}
	}
	return 0;
}

void ProcessNodeStrNodesInit()
{
	if (ProcessNodeStrNodeList)  return ;
	static OneParameter RaiseProcessNodeStrList[] = {
		{0}
	};
	UserParameters * RaiseMemberParam = new UserParameters
		(RaiseProcessNodeStrList);

	Procedure * MemberProcRaise = new Procedure("Raise", Raise,
		RaiseMemberParam, "void", 0, "raise any window referencing this node");
	static FloatParam ProcessNodeStrSetSampleRateRateParam = {
		 1.0, 0,  0,  1.e-60,  0,  1.e60};
	static IntParam ProcessNodeStrSetSampleRateChannelParam = {
		 0, 0,  0,  0, 0, 32767};
	static OneParameter SetSampleRateProcessNodeStrList[] = {
		{"Rate", 0, "sample rate for node output"
			, 0, &ProcessNodeStrSetSampleRateRateParam},
		{"Channel", 0, "output channel to set sample rate for"
			, &ProcessNodeStrSetSampleRateChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * SetSampleRateMemberParam = new UserParameters
		(SetSampleRateProcessNodeStrList);

	Procedure * MemberProcSetSampleRate = new Procedure("SetSampleRate", SetSampleRate,
		SetSampleRateMemberParam, "void", 0, "set the sample rate for the network");
	static IntParam ProcessNodeStrDisplayInputTimingChannelParam = {
		 0, 0, 0, -32767, 0, 32767};
	static OneParameter DisplayInputTimingProcessNodeStrList[] = {
		{"Channel", 0, "input channel to display timing for"
			, &ProcessNodeStrDisplayInputTimingChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * DisplayInputTimingMemberParam = new UserParameters
		(DisplayInputTimingProcessNodeStrList);

	Procedure * MemberProcDisplayInputTiming = new Procedure("DisplayInputTiming", DisplayInputTiming,
		DisplayInputTimingMemberParam, "void", 0, "display the timing of the selected input channel");
	static IntParam ProcessNodeStrDisplayOutputTimingChannelParam = {
		 0, 0,  0,  0, 0, 32767};
	static OneParameter DisplayOutputTimingProcessNodeStrList[] = {
		{"Channel", 0, "output channel to display timing for"
			, &ProcessNodeStrDisplayOutputTimingChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * DisplayOutputTimingMemberParam = new UserParameters
		(DisplayOutputTimingProcessNodeStrList);

	Procedure * MemberProcDisplayOutputTiming = new Procedure("DisplayOutputTiming", DisplayOutputTiming,
		DisplayOutputTimingMemberParam, "void", 0, "display the timing of the selected output channel");
	static OneParameter EditProcessNodeStrList[] = {
		{0}
	};
	UserParameters * EditMemberParam = new UserParameters
		(EditProcessNodeStrList);

	Procedure * MemberProcEdit = new Procedure("Edit", Edit,
		EditMemberParam, "void", 0, "make this node available for editing in a graphical network");
	static OneParameter UnlinkProcessNodeStrList[] = {
		{0}
	};
	UserParameters * UnlinkMemberParam = new UserParameters
		(UnlinkProcessNodeStrList);

	Procedure * MemberProcUnlink = new Procedure("Unlink", Unlink,
		UnlinkMemberParam, "void", 0, "unlink this node and connected nodes");
	static IntParam ProcessNodeStrLinkInChannelParam = {
		 0, 0,  0,  0, 0, 32767};
	static OneParameter LinkInProcessNodeStrList[] = {
		{"Channel", 0, "input channel to link to"
			, &ProcessNodeStrLinkInChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * LinkInMemberParam = new UserParameters
		(LinkInProcessNodeStrList);

	Procedure * MemberProcLinkIn = new Procedure("LinkIn", LinkIn,
		LinkInMemberParam, "Node&", 0, "select the next input channel to link to");
	static OneParameter NextFreeInputProcessNodeStrList[] = {
		{0}
	};
	UserParameters * NextFreeInputMemberParam = new UserParameters
		(NextFreeInputProcessNodeStrList);

	Procedure * MemberProcNextFreeInput = new Procedure("NextFreeInput", NextFreeInput,
		NextFreeInputMemberParam, "void", 0, "display next free input link");
	static OneParameter NextFreeOutputProcessNodeStrList[] = {
		{0}
	};
	UserParameters * NextFreeOutputMemberParam = new UserParameters
		(NextFreeOutputProcessNodeStrList);

	Procedure * MemberProcNextFreeOutput = new Procedure("NextFreeOutput", NextFreeOutput,
		NextFreeOutputMemberParam, "void", 0, "display next free output link");
static ValueType * ProcessNodeStrMembers[10] ;
	int ii = 0 ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcRaise) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcSetSampleRate) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayInputTiming) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayOutputTiming) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcEdit) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcUnlink) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcLinkIn) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcNextFreeInput) ;
	ProcessNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcNextFreeOutput) ;
	ProcessNodeStrMembers[ii++] = 0 ;
	ProcessNodeStrNodeList = new EntityList;
	IntEntProcessNodeStr = new InteractiveEntity("ProcessNodeStr", ProcessNodeStrNodeList,
		0, InteractiveNode, "procstr.h",
		ProcessNodeStrMembers, "Node");
	TheNodes->Append(IntEntProcessNodeStr);
} // end initalization

static InitObj LocalInit(ProcessNodeStrNodesInit, "ProcessNodeStr", "Node");

