#include <complex.h>
#include <signal.h>
#include "ObjProDSP/portable.h"
#include "ObjProComGui/usercom.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProArithGen/artherr.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/mask.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * MaskWordNodeList = 0 ;
static InteractiveEntity * IntEntMaskWord ;
void MaskWordNodesInit();
MaskWord::MaskWord (const char * Name, int32 Mask):
	ProcessNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAnyInt), 
	 new StreamStr(SizeVariable , SizeVariable , TheArithType == ArithType::ArithInt16 ? ArithType::ArithInt16 : ArithType::ArithInt32), 0, 1, 1, 0, 0, TimingTypeLinear)
,
	Mask_1(Mask)
{
	if (!MaskWordNodeList) MaskWordNodesInit() ;
	MaskWordNodeList->Append(MakeDeclaredEntity(this, IntEntMaskWord)) ;
	InitArithType(TheArithType);
	NewMenuItem("MaskWord",GetName());
#line 40 "../mask.usr"
 
	int32 Temp = GetMask();
	TheMask = *(uint32 *) &Temp ;
#line 41 "../mask.cxx"
} // end constructor

MaskWord::~MaskWord()
{
	TheMenuServer->DeleteMenuItem("MaskWord",GetName());
	MaskWordNodeList->Delete(GetName()) ;
} // end destructor

int MaskWord::CheckSafeDelete()
{
	int Safe_Check_Return = UserEntity::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

MaskWord * MaskWordDef;

ErrCode MaskWord::DoNode(int32 k)
{
#line 54 "../mask.usr"
 
	for (int32 i = 0 ; i < k ; i++ ) 
		for (int32 b = 0; b< GetBlockSize(); b++)
			for (int32 l = 0 ; l < GetEltSize(); l++)
				WriteInteger(ReadInteger() & TheMask);
	return OK ;
#line 68 "../mask.cxx"
} // end kernel code

static UserEntity * MakeMaskWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int MaskWord::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntMaskWord->CppList(Out,Cmd,this);
}

void MaskWord::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeMaskWord(Out,EntityReqDescribeFull,*IntEntMaskWord, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("Mask");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetMask()));
		Out.NextFillOut(")");
		Out.NextFillOut("will be applied to each input sample to");
		Out.NextFillOut("create an output sample.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntMaskWord->GetOneParameter("Mask")->
			IntP->CurrentValue = Mask_1;
		break;
	}
} // end  list entity switch

void MaskWordNodesInit()
{
	if (MaskWordNodeList)  return ;

	static StringParam MaskWordNameParam =
		{"MaskWord", MakeNewEntityName, 0, LegalEntityName};
	static IntParam MaskWordMaskParam = {
		 0, 0, 0, -2.14748e+09, 0, 2.14748e+09};

	static OneParameter MaskWordParArray[] = {
		{"Name", 0, "node name", 0, 0, &MaskWordNameParam},
		{"Mask", 0, 
			"mask to be be applied to binary data stream",
			&MaskWordMaskParam},
		{0}
	};

	MaskWordNodeList = new EntityList;
	IntEntMaskWord = new InteractiveEntity("MaskWord", MaskWordNodeList,
		MakeMaskWord, InteractiveNode, "mask.h",
		0, "ProcessNodeStr");
	IntEntMaskWord->SetParameters(new UserParameters(MaskWordParArray));
	TheNodes->Append(IntEntMaskWord);
} // end initalization

static UserEntity * MakeMaskWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("MaskWord");
		Out.NextFillOut("copies its input to its output after applying a the");
		Out.NextFillOut("mask");
		Out.NextQuoteOut("Mask");
		Out.NextFillOut("to each sample.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int32 Mask =
			IntNode.GetIntParameterValue("Mask");
		return new MaskWord(Name, Mask);

	}
	}
	return 0;
}

static InitObj LocalInit(MaskWordNodesInit, "MaskWord", "ProcessNodeStr");

