#include <stream.h>
#include <fcntl.h>
#include <stdlib.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProShare/shared.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/innode.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
#include "ObjProDSPcom/getinf.h"
#include "ObjProDSPcom/infile.h"
#include "ObjProDSPint/netlnk.h"
static EntityList * InputNodeNodeList = 0 ;
static InteractiveEntity * IntEntInputNode ;
void InputNodeNodesInit();
InputNode::InputNode (const char * Name, const char * FileName, int16 Flags, 
		int32 DeltaOut):
	SignalStr(Name, 
	GetTheInputFile(this , FileName , Name , Flags , &TheInputFile),  new StreamStr(StreamNotInitialized), DeltaOut, TimingTypeLinear)
,
	FileName_1(FileName),
	Flags_2(Flags),
	DeltaOut_3(DeltaOut)
{
	if (!InputNodeNodeList) InputNodeNodesInit() ;
	InputNodeNodeList->Append(MakeDeclaredEntity(this, IntEntInputNode)) ;
	InitArithType(TheArithType);
	NewMenuItem("InputNode",GetName());
#line 113 "../innode.usr"
 
	Ctor();
#line 43 "../innode.cxx"
} // end constructor

InputNode::~InputNode()
{
	TheMenuServer->DeleteMenuItem("InputNode",GetName());
	InputNodeNodeList->Delete(GetName()) ;
#line 117 "../innode.usr"
 
	Dtor();
#line 53 "../innode.cxx"
} // end destructor

int InputNode::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

InputNode * InputNodeDef;

ErrCode InputNode::DoNode(int32 k)
{
#line 135 "../innode.usr"
 
	return TheKernel(k); 
#line 70 "../innode.cxx"
} // end kernel code

static UserEntity * MakeInputNode(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int InputNode::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntInputNode->CppList(Out,Cmd,this);
}

void InputNode::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeInputNode(Out,EntityReqDescribeFull,*IntEntInputNode, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the name of the disk file");
		Out.NextFillOut("to be read. If no file name is specified");
		Out.NextFillOut("(default 0) then the node name will be used.");
		Out.NextFillOut("If");
		Out.NextQuoteOut("Flags");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetFlags()));
		Out.NextFillOut(")");
		Out.NextFillOut("& 4 is set the sample rate is forced to");
		Out.NextFillOut("1, overwriting the default values.");
		Out.NextQuoteOut("DeltaOut");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetDeltaOut()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the minimum output size. The node is not");
		Out.NextFillOut("scheduled until space for");
		Out.NextQuoteOut("DeltaOut");
		Out.NextFillOut("words is available");
		Out.NextFillOut("in the output buffer. It will only write multiples");
		Out.NextFillOut("of");
		Out.NextQuoteOut("DeltaOut");
		Out.NextFillOut("samples.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntInputNode->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntInputNode->GetOneParameter("Flags")->
			IntP->CurrentValue = Flags_2;
		IntEntInputNode->GetOneParameter("DeltaOut")->
			IntP->CurrentValue = DeltaOut_3;
		break;
	}
} // end  list entity switch

static ValueType * DisplayHeader(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("DisplayHeader");
		Out.NextFillOut("displays the parameters read from file");
		Out.NextQuoteOut("FileName");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("These include the original node name that generated the file,");
		Out.NextFillOut("the caption for this node, the number of input channels,");
		Out.NextFillOut("and the number of scalar elements in a sample. The arithmetic");
		Out.NextFillOut("type is also shown. The output channels and");
		Out.NextFillOut("sample size for this node are determined by these values. If the");
		Out.NextFillOut("data in the file is in a different arithmetic format");
		Out.NextFillOut("than that currently in use, the file data will be converted.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((InputNode * )This)->DisplayHeader(
		);		}
	}
	return 0;
}

static ValueType * IgnoreHeaderCount(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The data file header contains a count of the number of");
		Out.NextFillOut("machine words in each channel. This count is written at");
		Out.NextFillOut("the time the node creating the file is deleted. If ObjectProDSP");
		Out.NextFillOut("exits abnormally then these counts may never be set");
		Out.NextFillOut("and one will not be able to read any of the data in the");
		Out.NextFillOut("file. This option causes these counts to be ignored.");
		Out.NextFillOut("The result is that data will be read until the physical");
		Out.NextFillOut("end of file. This may result in samples of all 0 being");
		Out.NextFillOut("read at the end of the file that were never written to it.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((InputNode * )This)->IgnoreHeaderCount(
		);		}
	}
	return 0;
}

void InputNodeNodesInit()
{
	if (InputNodeNodeList)  return ;

	static StringParam InputNodeNameParam =
		{"InputNode", MakeNewEntityName, 0, LegalEntityName};
	static StringParam InputNodeFileNameParam = {
		 0, 0, 0};
	static IntParam InputNodeFlagsParam = {
		 0, 0, 0, -32767, 0, 32767};
	static IntParam InputNodeDeltaOutParam = {
		 1, 0,  0,  1,  0,  65536};

	static OneParameter InputNodeParArray[] = {
		{"Name", 0, "node name", 0, 0, &InputNodeNameParam},
		{"FileName", 0, 
			"name of disk file to read",
			0, 0, &InputNodeFileNameParam},
		{"Flags", 0, 
			"flags for arithmetic type and other option",
			&InputNodeFlagsParam, 0, 0, 0, 0, 1},
		{"DeltaOut", 0, 
			"minimum output chunk size",
			&InputNodeDeltaOutParam, 0, 0, 0, 0, 1},
		{0}
	};

	static OneParameter DisplayHeaderInputNodeList[] = {
		{0}
	};
	UserParameters * DisplayHeaderMemberParam = new UserParameters
		(DisplayHeaderInputNodeList);

	Procedure * MemberProcDisplayHeader = new Procedure("DisplayHeader", DisplayHeader,
		DisplayHeaderMemberParam, "void", 0, "display the caption and parameters read from the disk");
	static OneParameter IgnoreHeaderCountInputNodeList[] = {
		{0}
	};
	UserParameters * IgnoreHeaderCountMemberParam = new UserParameters
		(IgnoreHeaderCountInputNodeList);

	Procedure * MemberProcIgnoreHeaderCount = new Procedure("IgnoreHeaderCount", IgnoreHeaderCount,
		IgnoreHeaderCountMemberParam, "void", 0, "ignore the word counts in the data file header");
static ValueType * InputNodeMembers[3] ;
	int ii = 0 ;
	InputNodeMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayHeader) ;
	InputNodeMembers[ii++] = new ValueType(DecProcedure, MemberProcIgnoreHeaderCount) ;
	InputNodeMembers[ii++] = 0 ;
	InputNodeNodeList = new EntityList;
	IntEntInputNode = new InteractiveEntity("InputNode", InputNodeNodeList,
		MakeInputNode, InteractiveSignal, "innode.h",
		InputNodeMembers, "SignalStr");
	IntEntInputNode->SetParameters(new UserParameters(InputNodeParArray));
	TheNodes->Append(IntEntInputNode);
} // end initalization

static UserEntity * MakeInputNode(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("InputNode");
		Out.NextFillOut("reads input from disk file");
		Out.NextQuoteOut("FileName");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("The number of channels and the number of multiplexed elements");
		Out.NextFillOut("in a sample are read from the header of the disk file.");
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayHeader");
		Out.NextFillOut("will give the values of all the");
		Out.NextFillOut("information read from the disk file header.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		int16 Flags =
			IntNode.GetIntParameterValue("Flags");
		int32 DeltaOut =
			IntNode.GetIntParameterValue("DeltaOut");
		return new InputNode(Name, FileName, Flags, DeltaOut);

	}
	}
	return 0;
}

static InitObj LocalInit(InputNodeNodesInit, "InputNode", "SignalStr");

