#include <complex.h>
#include <stream.h>
#include "ObjProArith/hrdarth.h"
#include "ObjProGui/sigintfc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/xyplt.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
#include "ObjProDSPgui/xyplotc.h"
static EntityList * EyePlotNodeList = 0 ;
static InteractiveEntity * IntEntEyePlot ;
void EyePlotNodesInit();
EyePlot::EyePlot (const char * Name, double SamplesPerPlot, const char * Caption):
	GenericPlotStr(Name, 1,  new StreamStr(2 , SizeVariable), Caption, 
	0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 1, 0, TimingTypeLinear, 
	PlotDynDyn, SamplesPerPlot, PlotPairs)
,
	SamplesPerPlot_1(SamplesPerPlot),
	Caption_2(Caption)
{
	if (!EyePlotNodeList) EyePlotNodesInit() ;
	EyePlotNodeList->Append(MakeDeclaredEntity(this, IntEntEyePlot)) ;
	InitArithType(TheArithType);
	NewMenuItem("EyePlot",GetName());
} // end constructor

EyePlot::~EyePlot()
{
	TheMenuServer->DeleteMenuItem("EyePlot",GetName());
	EyePlotNodeList->Delete(GetName()) ;
} // end destructor

int EyePlot::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double EyePlot::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 59 "../xyplt.usr"
	return 0.0;
	// timing is irrelevant for a node with no output channels
#line 55 "../xyplt.cxx"
} // end timing code

EyePlot * EyePlotDef;

ErrCode EyePlot::DoNode(int32 k)
{
#line 63 "../xyplt.usr"
 
	DynamicInit();
	CheckRemoteSetup() ;
	for (int32 i = 0 ; i < k ; i++ ) 
		for (int32 b = 0 ; b < GetBlockSize(); b++)
			WriteDataWord(ReadCxWord());
	return OK ;
#line 70 "../xyplt.cxx"
} // end kernel code

static UserEntity * MakeEyePlot(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int EyePlot::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntEyePlot->CppList(Out,Cmd,this);
}

void EyePlot::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeEyePlot(Out,EntityReqDescribeFull,*IntEntEyePlot, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("EyePlot");
		Out.NextFillOut("generates a series of plots with");
		Out.NextQuoteOut("SamplesPerPlot");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetSamplesPerPlot()));
		Out.NextFillOut(")");
		Out.NextFillOut("in each display. If the input block size");
		Out.NextFillOut("is not 1 then that value is overrides this parameter.");
		Out.NextFillOut("The plot caption is a string that will be displayed");
		Out.NextFillOut("at the base of the plot. The default value of 0");
		Out.NextFillOut("causes the plot node name to be used for the caption.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntEyePlot->GetOneParameter("SamplesPerPlot")->
			FloatP->CurrentValue = SamplesPerPlot_1;
		IntEntEyePlot->GetOneParameter("Caption")->
			StringP->CurrentValue = Caption_2;
		break;
	}
} // end  list entity switch

void EyePlotNodesInit()
{
	if (EyePlotNodeList)  return ;

	static StringParam EyePlotNameParam =
		{"EyePlot", MakeNewEntityName, 0, LegalEntityName};
	static FloatParam EyePlotSamplesPerPlotParam = {
		 400., 0,  0,  3., 0, 1e+100};
	static StringParam EyePlotCaptionParam = {
		 0, 0, 0};

	static OneParameter EyePlotParArray[] = {
		{"Name", 0, "node name", 0, 0, &EyePlotNameParam},
		{"SamplesPerPlot", 0, 
			"the number of samples in one diaplay",
			0, &EyePlotSamplesPerPlotParam, 0, 0, 0, 1},
		{"Caption", 0, 
			"plot caption",
			0, 0, &EyePlotCaptionParam, 0, 0, 1},
		{0}
	};

	EyePlotNodeList = new EntityList;
	IntEntEyePlot = new InteractiveEntity("EyePlot", EyePlotNodeList,
		MakeEyePlot, InteractiveDisplay, "xyplt.h",
		0, "GenericPlotStr");
	IntEntEyePlot->SetParameters(new UserParameters(EyePlotParArray));
	TheNodes->Append(IntEntEyePlot);
} // end initalization

static UserEntity * MakeEyePlot(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("EyePlot");
		Out.NextFillOut("displays a complex signal on a single");
		Out.NextFillOut("eye plot or X versus Y format. The real value of a sample determines");
		Out.NextFillOut("the X coordinate and the imaginary value determines the Y coordinate.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		double SamplesPerPlot =
			IntNode.GetFloatParameterValue("SamplesPerPlot");
		const char * Caption =
			IntNode.GetStringParameterValue("Caption");
		return new EyePlot(Name, SamplesPerPlot, Caption);

	}
	}
	return 0;
}

static InitObj LocalInit(EyePlotNodesInit, "EyePlot", "GenericPlotStr");

