#include "ObjProNet/dfnode.h"

#include "ObjProUsr/dsplstr.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
#include "ObjProDSPcom/dispmem.h"
static EntityList * DisplayNodeStrNodeList = 0 ;
static InteractiveEntity * IntEntDisplayNodeStr ;
void DisplayNodeStrNodesInit();
DisplayNodeStr::DisplayNodeStr (const char * Name, int16 in, int32 DeltaIn, 
		StreamStr*StreamIn, TimingType TheTimingType):
	Node(Name, in, 0, StreamIn, 0, 0, DeltaIn, 1, 0, 0, TheTimingType)
,
	in_1(in),
	DeltaIn_2(DeltaIn),
	StreamIn_3(StreamIn),
	TheTimingType_4(TheTimingType)
{
} // end constructor

DisplayNodeStr::~DisplayNodeStr()
{
} // end destructor

int DisplayNodeStr::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

static ValueType * Raise(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("Raise");
		Out.NextFillOut("will cause a window displaying this network to be raised");
		Out.NextFillOut("to the top level over any overlapping windows.");
		Out.NextFillOut("Examples of windows that will be affected are a network display");
		Out.NextFillOut("containing this node or a plot window for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((DisplayNodeStr * )This)->Raise(
		);		}
	}
	return 0;
}

static ValueType * DisplayInputTiming(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayInputTiming");
		Out.NextFillOut("displays the timing");
		Out.NextFillOut("of the selects input channel for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Channel =
			Param->GetIntParameterValue("Channel");

		((DisplayNodeStr * )This)->DisplayInputTiming(
		Channel);		}
	}
	return 0;
}

static ValueType * Edit(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("If this node is not linked in an existing network it will be");
		Out.NextFillOut("added to the display of the network currently being edited. If");
		Out.NextFillOut("there is no such network one will be created.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((DisplayNodeStr * )This)->Edit(
		);		}
	}
	return 0;
}

static ValueType * Unlink(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("Unlink");
		Out.NextFillOut("disconnects this node from the");
		Out.NextFillOut("DSP network it is linked in.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((DisplayNodeStr * )This)->Unlink(
		);		}
	}
	return 0;
}

static ValueType * LinkIn(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The");
		Out.NextQuoteOut("LinkIn");
		Out.NextFillOut("member function selects the");
		Out.NextFillOut("next input channel to link to. It's single parameter (");
		Out.NextFillOutConcat("Channel");
		Out.NextFillOutConcat(")");
		Out.NextFillOut("specifies the channel index. Ordinarily the");
		Out.NextFillOut("first unused channel is linked to. This function");
		Out.NextFillOut("overrides that default.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Channel =
			Param->GetIntParameterValue("Channel");

		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((DisplayNodeStr * )This)->LinkIn(
		Channel));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * NextFreeInput(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("This function displays the next available input link for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((DisplayNodeStr * )This)->NextFreeInput(
		);		}
	}
	return 0;
}

void DisplayNodeStrNodesInit()
{
	if (DisplayNodeStrNodeList)  return ;
	static OneParameter RaiseDisplayNodeStrList[] = {
		{0}
	};
	UserParameters * RaiseMemberParam = new UserParameters
		(RaiseDisplayNodeStrList);

	Procedure * MemberProcRaise = new Procedure("Raise", Raise,
		RaiseMemberParam, "void", 0, "raise any window referencing this node");
	static IntParam DisplayNodeStrDisplayInputTimingChannelParam = {
		 0, 0, 0, -32767, 0, 32767};
	static OneParameter DisplayInputTimingDisplayNodeStrList[] = {
		{"Channel", 0, "input channel to display timing for"
			, &DisplayNodeStrDisplayInputTimingChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * DisplayInputTimingMemberParam = new UserParameters
		(DisplayInputTimingDisplayNodeStrList);

	Procedure * MemberProcDisplayInputTiming = new Procedure("DisplayInputTiming", DisplayInputTiming,
		DisplayInputTimingMemberParam, "void", 0, "display the timing of the selected input channel");
	static OneParameter EditDisplayNodeStrList[] = {
		{0}
	};
	UserParameters * EditMemberParam = new UserParameters
		(EditDisplayNodeStrList);

	Procedure * MemberProcEdit = new Procedure("Edit", Edit,
		EditMemberParam, "void", 0, "make this node available for editing in a graphical network");
	static OneParameter UnlinkDisplayNodeStrList[] = {
		{0}
	};
	UserParameters * UnlinkMemberParam = new UserParameters
		(UnlinkDisplayNodeStrList);

	Procedure * MemberProcUnlink = new Procedure("Unlink", Unlink,
		UnlinkMemberParam, "void", 0, "unlink this node");
	static IntParam DisplayNodeStrLinkInChannelParam = {
		 0, 0,  0,  0, 0, 32767};
	static OneParameter LinkInDisplayNodeStrList[] = {
		{"Channel", 0, "input channel to link to"
			, &DisplayNodeStrLinkInChannelParam},
		{0}
	};
	UserParameters * LinkInMemberParam = new UserParameters
		(LinkInDisplayNodeStrList);

	Procedure * MemberProcLinkIn = new Procedure("LinkIn", LinkIn,
		LinkInMemberParam, "Node&", 0, "select the next input channel to link to");
	static OneParameter NextFreeInputDisplayNodeStrList[] = {
		{0}
	};
	UserParameters * NextFreeInputMemberParam = new UserParameters
		(NextFreeInputDisplayNodeStrList);

	Procedure * MemberProcNextFreeInput = new Procedure("NextFreeInput", NextFreeInput,
		NextFreeInputMemberParam, "void", 0, "display next free input link");
static ValueType * DisplayNodeStrMembers[7] ;
	int ii = 0 ;
	DisplayNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcRaise) ;
	DisplayNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayInputTiming) ;
	DisplayNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcEdit) ;
	DisplayNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcUnlink) ;
	DisplayNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcLinkIn) ;
	DisplayNodeStrMembers[ii++] = new ValueType(DecProcedure, MemberProcNextFreeInput) ;
	DisplayNodeStrMembers[ii++] = 0 ;
	DisplayNodeStrNodeList = new EntityList;
	IntEntDisplayNodeStr = new InteractiveEntity("DisplayNodeStr", DisplayNodeStrNodeList,
		0, InteractiveNode, "dsplstr.h",
		DisplayNodeStrMembers, "Node");
	TheNodes->Append(IntEntDisplayNodeStr);
} // end initalization

static InitObj LocalInit(DisplayNodeStrNodesInit, "DisplayNodeStr", "Node");

