#include <complex.h>
#include <stream.h>
#include <fstream.h>
#include "ObjProArith/hrdarth.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/ascfle.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * AsciiFileNodeList = 0 ;
static InteractiveEntity * IntEntAsciiFile ;
void AsciiFileNodesInit();
AsciiFile::AsciiFile (const char * Name, const char * FileName, int16 Hex, 
		int16 NoGroup, int16 NoHeader):
	DisplayNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAny), TimingTypeLinear)
,
	FileName_1(FileName),
	Hex_2(Hex),
	NoGroup_3(NoGroup),
	NoHeader_4(NoHeader)
{
	if (!AsciiFileNodeList) AsciiFileNodesInit() ;
	AsciiFileNodeList->Append(MakeDeclaredEntity(this, IntEntAsciiFile)) ;
	InitArithType(TheArithType);
	NewMenuItem("AsciiFile",GetName());
#line 110 "../ascfle.usr"
 
	Ctor();
#line 39 "../ascfle.cxx"
} // end constructor

ErrCode AsciiFile::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tAsciiFileStaticInitinteger_read_flag_" << GetName() << "";
	return OK;
}

ErrCode AsciiFile::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int AsciiFileStaticInitinteger_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(integer_read_flag)) ;

	Outs << ";\n";
	return OK;
}

AsciiFile::~AsciiFile()
{
	TheMenuServer->DeleteMenuItem("AsciiFile",GetName());
	AsciiFileNodeList->Delete(GetName()) ;
#line 114 "../ascfle.usr"
 
	Dtor();
#line 66 "../ascfle.cxx"
} // end destructor

int AsciiFile::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double AsciiFile::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 140 "../ascfle.usr"
	return 0.0;
	// timing is irrelevant for a node with no output channels
#line 81 "../ascfle.cxx"
} // end timing code

AsciiFile * AsciiFileDef;

ErrCode AsciiFile::DoNode(int32 k)
{
#line 144 "../ascfle.usr"
 
	return Kernel(k);
#line 91 "../ascfle.cxx"
} // end kernel code

static UserEntity * MakeAsciiFile(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int AsciiFile::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntAsciiFile->CppList(Out,Cmd,this);
}

void AsciiFile::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeAsciiFile(Out,EntityReqDescribeFull,*IntEntAsciiFile, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the output ascii file name");
		Out.NextFillOut("head of the listing. If no caption is specified");
		Out.NextFillOut("(default 0) then the node name will be used.");
		Out.NextQuoteOut("Hex");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetHex()));
		Out.NextFillOut(")");
		Out.NextFillOutConcat(", when set, writes output in hexadecimal format.");
		Out.NextFillOut("If the value will not fit in a 32 bit integer it is hard");
		Out.NextFillOut("limited and a warning is generated.");
		Out.NextQuoteOut("NoGroup");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetNoGroup()));
		Out.NextFillOut(")");
		Out.NextFillOutConcat(", if set, writes data one word per line.");
		Out.NextFillOut("The default is to write the words in a sample");
		Out.NextFillOut("on a single line (up to 20 words per sample)");
		Out.NextFillOut("and to put brackets `");
		Out.NextFillOutConcat("{}");
		Out.NextFillOutConcat("' around");
		Out.NextFillOut("blocks if the block size is larger then the");
		Out.NextFillOut("sample size. If");
		Out.NextQuoteOut("NoGroup");
		Out.NextFillOut("is set then the data");
		Out.NextFillOut("is written one per line with no grouping information.");
		Out.NextFillOut("The default is to write a data header that describes");
		Out.NextFillOut("the data format, the time it was created and gives");
		Out.NextFillOut("the names of the creating node and network. If this");
		Out.NextFillOut("option is set this header is omitted.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntAsciiFile->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntAsciiFile->GetOneParameter("Hex")->
			IntP->CurrentValue = Hex_2;
		IntEntAsciiFile->GetOneParameter("NoGroup")->
			IntP->CurrentValue = NoGroup_3;
		IntEntAsciiFile->GetOneParameter("NoHeader")->
			IntP->CurrentValue = NoHeader_4;
		break;
	}
} // end  list entity switch

static ValueType * SetHex(OutTokens&,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
	break ;
case EntityReqDescribeFull:
	break ;
case EntityReqCall:
		{		// Call procedure
				int16 Hex =
			Param->GetIntParameterValue("Hex");
		((AsciiFile *) This)->SetHex(Hex);
		return 0 ;
	}
	}
	return 0;
}

void AsciiFileNodesInit()
{
	if (AsciiFileNodeList)  return ;

	static StringParam AsciiFileNameParam =
		{"AsciiFile", MakeNewEntityName, 0, LegalEntityName};
	static StringParam AsciiFileFileNameParam = {
		 0, 0, 0};
	static IntParam AsciiFileHexParam = {
		 0, 0,  0,  0,  0,  1};
	static IntParam AsciiFileNoGroupParam = {
		 0, 0,  0,  0,  0,  1};
	static IntParam AsciiFileNoHeaderParam = {
		 0, 0,  0,  0,  0,  1};

	static OneParameter AsciiFileParArray[] = {
		{"Name", 0, "node name", 0, 0, &AsciiFileNameParam},
		{"FileName", 0, 
			"output file name (defaults to node name)",
			0, 0, &AsciiFileFileNameParam},
		{"Hex", 0, 
			"option to output data in hex format",
			&AsciiFileHexParam, 0, 0, 0, 0, 1},
		{"NoGroup", 0, 
			"option to not group complex elements on one line",
			&AsciiFileNoGroupParam, 0, 0, 0, 0, 1},
		{"NoHeader", 0, 
			"option to omit data header",
			&AsciiFileNoHeaderParam, 0, 0, 0, 0, 1},
		{0}
	};

	static OneParameter SetHexAsciiFileList[] = {
		{"Hex", 0, "option to output data in hex format",
			 &AsciiFileHexParam, 0, 0, 0, 0, 1},
			{0}
	};
	UserParameters * SetHexMemberParam = new UserParameters
		(SetHexAsciiFileList);

	Procedure * SetMemberProcHex = new Procedure("SetHex", SetHex,
		 SetHexMemberParam, "void");
static ValueType * AsciiFileMembers[2] ;
	int ii = 0 ;
	AsciiFileMembers[ii++] = new ValueType(DecProcedure, SetMemberProcHex) ;
	AsciiFileMembers[ii++] = 0 ;
	AsciiFileNodeList = new EntityList;
	IntEntAsciiFile = new InteractiveEntity("AsciiFile", AsciiFileNodeList,
		MakeAsciiFile, InteractiveDisplay, "ascfle.h",
		AsciiFileMembers, "DisplayNodeStr");
	IntEntAsciiFile->SetParameters(new UserParameters(AsciiFileParArray));
	TheNodes->Append(IntEntAsciiFile);
} // end initalization

static UserEntity * MakeAsciiFile(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("AsciiFile");
		Out.NextFillOut("writes an ascii file of the data sent to it.");
		Out.NextFillOut("By default the data is grouped as one sample per line with");
		Out.NextFillOut("the words in each sample separated by a space. If blocks");
		Out.NextFillOut("are larger than one sample they are grouped in side");
		Out.NextFillOut("curly brackets `");
		Out.NextFillOutConcat("{}");
		Out.NextFillOutConcat("'. This formatting information can be");
		Out.NextFillOut("removed with the");
		Out.NextQuoteOut("NoGroup");
		Out.NextFillOut("option. The output format");
		Out.NextFillOut("is accurate enough to fully represent the internal");
		Out.NextFillOut("data value.");
		Out.NextQuoteOut("Hex");
		Out.NextFillOut("uses a hexadecimal format. (Values that");
		Out.NextFillOut("do not fit in a 32 bit integer are hard limited and generate");
		Out.NextFillOut("a warning with");
		Out.NextQuoteOut("Hex");
		Out.NextFillOut("format.)");
		Out.NextFillOut("describes the data format and the data source. It can");
		Out.NextFillOut("be omitted using the");
		Out.NextQuoteOut("NoHeader");
		Out.NextFillOut("option.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		int16 Hex =
			IntNode.GetIntParameterValue("Hex");
		int16 NoGroup =
			IntNode.GetIntParameterValue("NoGroup");
		int16 NoHeader =
			IntNode.GetIntParameterValue("NoHeader");
		return new AsciiFile(Name, FileName, Hex, NoGroup, NoHeader);

	}
	}
	return 0;
}

static InitObj LocalInit(AsciiFileNodesInit, "AsciiFile", "DisplayNodeStr");

