#include <stdlib.h>
#include "netlnk.h"
#include "cgidbg.h"
#include "ramio.h"

void DfNodeInLink::Init(int element_size,int32 block_size,
	int buf_inx, OutputBuffer *buf)
{
	ElementSize = element_size ;
	BlockSize = block_size ;
	BufferChannelIndex = buf_inx ;
	TheBuffer = buf ;
}

ErrCode DfNodeInLink::Reset()
{
	return OK ;
}

ErrCode DfNodeOutLink::Reset()
{
	if (TheBuffer) return TheBuffer->Reset();
	return OK ;
}


void DfNodeOutLink::Init(int element_size,int32 block_size, OutputBuffer *buf)
{
	ElementSize = element_size ;
	BlockSize = block_size ;
	TheBuffer = buf ;
}

int32 DfNodeOutLink::GetSpace() const 
{
	return TheBuffer->GetAvailableSpace() ;
}

int32 DfNodeOutLink::GetDynamicCount() const
{
	int32 Space = GetSpace();
/*
 *	TheLog << "DfNodeOutLink::GetDynamicCount Space = " << Space <<
 *		", Min = " << MinimumExecute << "\n" ;
 */
	if (Space < MinimumExecute) return 0 ;
	int32 Return = (Space * DivisorFactor) >> DivisorShift ;
/*
 *	TheLog << "Return = " << Return << ", DivisorFactor = " <<
 *		DivisorFactor << ", DivisorShift = " << DivisorShift << "\n" ;
 */
	return Return ;
}

int32 DfNodeInLink::GetDynamicCount(int seq_index) const
{
	int32 Data = GetAvailableData() ;
	if (!seq_index) Data -= Overlap * ElementSize * BlockSize ;
/*
 *	TheLog << "DfNodeInLink::GetDynamicCount Data = " << Data <<
 *		", Min = " << MinimumExecute << "\n" ;
 */


	if (Data < MinimumExecute) return 0 ;
	int32 Return = (Data * DivisorFactor) >> DivisorShift ;
/*
 *	TheLog << "Return = " << Return << ", DivisorFactor = " <<
 *		DivisorFactor << ", DivisorShift = " << DivisorShift << "\n" ;
 */
 

	return Return ;
}

TargetNode * DfNodeInLink::GetDriverNode() const
{
	return TheBuffer->DriverNode ;
}


