/*
 *  tardb.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  tardb.h   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "slist.h"

struct NamePair {
	const char * Reference ;
	const char * Value ;
	int AlreadyOutput ;
	NamePair(const char * A, const char *B):
		Reference(A),Value(B),AlreadyOutput(0){}
	const char * Check(const char * ref) ;
};

class NamePairList:public SingleList {
public:
	ErrCode Insert(NamePair *nt) {return SingleList::Insert(nt);}
	ErrCode Append(NamePair *nt) {return SingleList::Append(nt);}
	ErrCode Append(const char * A, const char * B) ;
	NamePair * Get()   {return (NamePair *) SingleList::Get();}
	NamePair * Pop() {return (NamePair *) SingleList::Pop();}
	NamePair * GetNFromTop(int N) ;
	NamePair * GetNthEntry(int N) ;
	NamePairList(){;}
	int Size(){return SingleList::Size();}
	NamePair * FindValue(const char * Reference);
	void ClearAlreadyOutput();
} ;

class NamePairListIterator:public SingleListIterator {
public:
	NamePairListIterator(NamePairList& df):SingleListIterator((SingleList&) df){}
	NamePair * operator()()
		{return (NamePair *) Next();}
};


extern NamePairList * TargetDataBase ;
