/*  interinit.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <string.h>
#include "interinit.h"
#include "cgidbg.h"
#include "intfc.h"

InitList * InitInteractiveEntities = 0;


InitObj::InitObj(InterInit init, const char * name, const char * base)
{
	// LogOut << "InitObj(," << name << ", " << base << ")" << "\n" ;
	Init=init;
	Name=name ;
	Base=base ;
/*
 *	LogOut << "InitObj::InotObj( 0x" << hex((long)init) << ", " <<
 *		name << ", " << base << ")\n" ;
 */
	if (!InitInteractiveEntities) InitInteractiveEntities = new InitList;
	InitInteractiveEntities->Append(this);
}


void InitList::BaseDone(const char * BaseName)
{
	// LogOut << "BaseDone(" << BaseName << ")\n" ;
	InitListIterator Next(*this);
	InitObj * Obj ;
	while (Obj = Next()) if (Obj->Base) if (!strcmp(Obj->Base,BaseName)) Obj->Base = 0 ;
}

void InitList::DoInit()
{
	// LogOut << "DoInit\n" ;
	InteractiveInit();
	int NotDone = 1 ;
	const char * NotResolved = 0 ;
	BaseDone("DfNode");
	while(NotDone) {
		NotDone = 0 ;
		InitListIterator Next(*this);
		InitObj * Obj ;
		NotResolved = 0 ;
		while (Obj = Next()) if (Obj->Name) if (Obj->Base) {
			if (AllEntityLists->IsPrimaryEntity(Obj->Base)) {
				Obj->Base = 0 ;
				NotDone = 1 ;
			} else NotResolved = Obj->Base ;
		} else {
			NotDone = 1 ;
/*
 *			LogOut << "Calling init for " << Obj->Name ;
 *			if (Obj->Base) LogOut << " with base " << Obj->Base ;
 *			LogOut <<  ".\n" ;
 */

			Obj->Init() ;
			BaseDone(Obj->Name);
			Obj->Name = 0 ;
		}
	}
	if (NotResolved) {
		TheLog << "Last base not resolved was `" << NotResolved <<
			"'\n" ;
		DbgError("IntiList::DoInit","can't initialize all classes");
	}
}
