#!/bin/sh
#  rebuild_validate.sh from ObjectProDSP 0.2
#  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
#  Licensed for free use and distribution under version 2 of the Gnu General
#  Public License. Please see file COPYING for details and restrictions.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
# script to create new set of validation scripts from a previous set
# this is seldom necessary or useful but was needed when facilites
# were added to preserve the menu state for menu commands. 
# New scripts are left in directory $OPD_ROOT/new_validatae

function make_start_script() { # new file, original file, output script
	echo 'Action 0x52 "NO SELECTION" "ObjectProDSP 0.1 for float arithmetic" # record actions' \
		> $3
	echo "Prompt \"$1\"" >> $3
	echo 'Action 0x10050 "NO SELECTION" "ObjectProDSP 0.1 for float arithmetic" # playback actions' \
		>> $3
	echo Prompt "\"$2\"" >> $3
}

function base_file_name() {
	OPD_BASE_FILE=${1##*/}
}

function make_new_scripts() { 
for i in $* ; do 
	make_start_script $OPD_SCR_NEW $i $OPD_SCR_TMP
	$OPD_ROOT/bin/opd $OPD_EXE_FLAGS -c -a $OPD_SCR_TMP

	# remove playback command from script file
	echo $OPD_ROOT/bin/cp_part \'"Prompt \"$i\""\' "< $OPD_SCR_NEW  \
		> $OPD_SCR_NEW2" > temp.sh
	bash temp.sh

	# get header documentation from original script file
	base_file_name $i
	$OPD_ROOT/bin/cp_part -u '######################################################## END OF VALIDATION LIST' \
		< $i > $OPD_BASE_FILE
	echo "#" >> $OPD_BASE_FILE
	
	# complete copy of new script file
	cat $OPD_SCR_NEW2 >> $OPD_BASE_FILE
done
}

if [ ! -e $OPD_ROOT/new_validate ] ;then mkdir $OPD_ROOT/new_validate ;fi
if [ ! -e $OPD_ROOT/new_validate/test_nodes ] ;then mkdir $OPD_ROOT/new_validate/test_nodes ;fi
cd $OPD_ROOT/new_validate
cp ../validate/* .
cd $OPD_ROOT/new_validate/test_nodes
OPD_SCR_TMP=temp.rec
OPD_SCR_NEW=new.rec
OPD_SCR_NEW2=new2.rec
INT16_SCRIPTS="$OPD_ROOT/validate/make_*_validate_int16.rec"
FLOAT_SCRIPTS="$OPD_ROOT/validate/make_*_validate.rec \
	$OPD_ROOT/validate/make_*_validate_float.rec"

OPD_EXE_FLAGS=
make_new_scripts $FLOAT_SCRIPTS

OPD_EXE_FLAGS=-i
make_new_scripts $INT16_SCRIPTS
