#!/bin/sh
#  create_interactive_node_test.sh from ObjectProDSP 0.2
#  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
#  Licensed for free use and distribution under version 2 of the Gnu General
#  Public License. Please see file COPYING for details and restrictions.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
#
OPD_DIR=${1%/*}
OPD_COMMAND=${1##*/}
OPD_TEST_LOG=$2
OPD_INT16=${OPD_DIR%_int16}
OPD_FLOAT=${OPD_DIR%_float}

if [ "$OPD_INT16" != "$OPD_DIR" ] ;then
	if [ -n "$3" ] ;then if [ "$3" != "int16" ] ;then exit 0 ;fi ;fi
	OPD_FLAG="-i" 
elif [ "$OPD_FLOAT" != "$OPD_DIR" ] ;then 
	if [ -n "$3" ] ;then if [ "$3" != "float" ] ;then exit 0 ;fi ;fi
	OPD_FLAG=
else
	echo "\`$OPD_DIR' contains \`.dpp' files but has unknown arithmetic." \
		>> $OPD_TEST_LOG
	exit
fi

echo "#"
echo "if ! pushd $OPD_DIR ;then exit 1 ;fi"
echo "if [ ! -d interactive ] ;then if ! mkdir interactive ;then exit 1 ;fi ;fi"
echo "if [ ! -d interactive/test_data ] ;then if ! ln -s $OPD_ROOT/validate/test_data/interactive \
	interactive/test_data ;then exit 1 ;fi ;fi"
echo "cd interactive"
echo "echo \"Doing \\\`$1' in \\\`$OPD_DIR/interactive' at \`date\`.\" >> $OPD_TEST_LOG"
echo "if ! $OPD_ROOT/bin/opd $OPD_FLAG -a $OPD_ROOT/validate/exit.rec \
-r ../$OPD_COMMAND -l $OPD_TEST_LOG ;then exit 1 ;fi"
if [ -z "$OPD_CREATE_SEPARATE_TARGET_BASE_LINE" ] ;then
	echo 'ln -f *.dat .. ; X=*.cmp ; if [ "*.cmp" != $X ] ;then ln -f *.cmp .. ;fi'
fi
echo "popd"
echo "echo \"Did \\\`$1' at \`date\`.\" >> $OPD_TEST_LOG"
