/*
 *  tarnodpar.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  tarnodpar.h   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef TARNODPAR_DOT_H
#define TARNODPAR_DOT_H
#include "ObjProGui/execseq.h"

class TargetNodeParameters {
	ExecutionSequence InitExecuteSequence ;
	ExecutionSequence ExecuteSequence ;
	DfNode& Parent ;
	int32 NeededExecutionCount ;
public:
	TargetNodeParameters(DfNode& parent, BufferStatus& obj);
	ExecutionSequence& GetInit() {return InitExecuteSequence;}
	ExecutionSequence& GetExecute() {return ExecuteSequence;}
	int32 * GetInitExecuteSequence() const
		{return InitExecuteSequence.Get(); }
	int32 * GetExecuteSequence() const {return ExecuteSequence.Get(); }
	int GetInitSize() const {return InitExecuteSequence.GetSize();}
	int GetExecuteSize() const {return ExecuteSequence.GetSize();}
	int32 GetInitCount(int i) const {return ExecuteSequence.Count(i);}
	int32 GetExecuteCount(int index) const 
		{return InitExecuteSequence.Count(index);}
	DfNode& GetNode() const {return Parent;}
	void EmitSequences(TraverseObject& obj);

	int32 GetNeededCount() const { return NeededExecutionCount; }
	void SetNeededCount(int32 count) {NeededExecutionCount = count ;}
	TargetAdjustState DoAdjust(Adjustment& TheAdjustment);
	TargetAdjustState TargetNodeParameters::EnlargeSequence(
		Adjustment& TheAdjustment) ;
	void ClearSequences();
	void dump(const char *);
};

#endif /* #ifdef TARNODPAR_DOT_H */
