/*
 *  dspe_app.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DSPE_APP_DOT_H
#define DSPE_APP_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/editnet.h"
#include "ObjProGen/errcode.h"
#include "ObjProDSP/arthtyp.h"
class ProcessNet ;

class DspApplication {
public:
	static const max_name_length ;
	static void network_edit(int32 id, const char * data, int size);
	static int make_target_mode();
	static int read_variable(const char * buf, double &value);
	static void set_make_target_mode();
	static void clear_make_target_mode();
	static void node_trace_on();
	static void node_trace_off();
	static void heap_check_on();
	static void heap_check_off();
	static void set_report_overflow_limit();
	static int overflow_check_limit();
	static int is_trace();
	static int is_heap();
	static ErrCode send_gui(CppEnums::edit_network cmd, const char * a,
		const char *b=0, int a_length = -1);
	static ArithType::ArithTypes * convert_code ;
	static int valid_object_name(const char * name);
	static const char * explain_legal_object_name() ;

	static int32 compare_disk_max_report();
	static void compare_disk_max_report(int32);
	static double compare_disk_tolerance();
	static void compare_disk_tolerance(double);
	static const char * compare_disk_error_file() ;
	static void compare_disk_error_file(const char *);
	static void OutputNode_replace_directory(const char * dir) ;
	static const char * OutputNode_replace_directory() ;
	static char * force_to_legal_name_del(char * existing,int force_not_used=1);
		// deletes `existing' if a new name is returned

	static char * force_to_legal_name(const char * existing,
		int force_not_used=1);
		// returns 0 if current name is OK otherwise new name is allocated
	static void set_redisplay(ProcessNet * to_display);
	static void check_redisplay();
	static const char * err_code_names[] ;
};
#endif /* #ifdef DSPE_APP_DOT_H */
