/*
 *  array.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  array.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
// support for one dimensional arrays (of any type) as parameters 
#ifndef ARRAY_DOT_H
#define ARRAY_DOT_H
#include "ObjProDSP/portable.h"
#include "ObjProGui/user.h"

typedef void * (*ArrayComputeBound)(enum CheckAction, struct OneParameter&,
	const struct OneParameter ** List = 0,class OutTokens * Out=0) ;

struct DoCheckArrayBound {
	ArrayComputeBound GetBound ;
	const struct OneParameter ** List ;
	void * Bound(OneParameter& p)
		{return GetBound(CheckActionCheck,p,List);}
} ;

struct GetParameterTemp ;

struct ArrayData {
	int32 Size ;
	enum DecType Type ;
	void * Data ;
	int Index ;
	ArrayData * clone(ArrayData& clone_from);
	int IsScalar() {return Size == -1;}
	ArrayData * SetArrayData(DecType typ, void * data);
	ArrayData * SetArrayData(int32 size, DecType typ, void * data = 0);
	ArrayData * SetArrayData(SingleList& TheList,DecType typ);
	int32 GetArraySize() {return Size;}
	void List(class OutTokens& Out);
	void Dump(OutTokens& Out);
	void CppDump(OutTokens& Out);
	int CppList(OutTokens& Out, CppListCmds Cmd) ;
	int GetIndex() const {return Index;}
	void SetIndex(int index) {Index = index;}
	int SameValue(ArrayData * Check) const ;
	double access(int index);
} ;

struct ArrayParam {
	enum DecType Type ;
	ArrayData * Default ;
	ArrayData * CurrentValue ;
	DoCheckArrayBound * CheckLower ;
	void * Lower ;
	DoCheckArrayBound * CheckUpper ;
	void * Upper ;
	int SizeLowerLimit ;
	int SizeUpperLimit ;
	void GetScalarParameter(GetParameterTemp& param);
	void GetParameter(const char *, OneParameter&,
		ValueType * Val,int i=0) ;
	void * GetParameterValue() ;
	int32 GetLengthParameterValue() ;
	void * TheLowerBound(struct OneParameter& p) ;
	void * TheUpperBound(struct OneParameter& p) ;
	void List(OneParameter&,OutTokens& Out) ;
	void ListValue(OneParameter&,OutTokens& Out) ;
	int IsScalar() {return Default->IsScalar();}
	void Dump(OutTokens& Out);
	void CppDump(OutTokens& Out);
	int CppList(OutTokens& Out, CppListCmds Cmd) ;
	void CppListHead(OutTokens& Out, CppListCmds Cmd) ;
	int CppListDec(OutTokens& Out, CppListCmds Cmd) ;
	int CppListDecEmit(OutTokens& Out, CppListCmds Cmd) ;
	int GetIndex() const {return Default->GetIndex();}
	void UseSuppliedvalues(GetParameterTemp& TempParam);
	ArrayData * ReadUserArrayName(char *RawBuf);
};

const char * UserNameOfType(DecType Type) ;
const char * UserNameOfType(DecType Type, CppListCmds Cmd) ;
extern const char * TheArrayDataName ;
extern int ArrayDataIndex ;
extern int ArrayDataIndexBase ;

#endif /* #ifdef ARRAY_DOT_H */
