/*
 *  gain.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef GAIN_DOT_H
#define GAIN_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class Gain: public TargetNode {
	int32  NumberOfOverflows;
	double  Scale_1;
public:
	Gain (const char * Name, double Scale,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~Gain();
	double GetScale() const {return Scale_1;}
	int32 GetNumberOfOverflows() const { return NumberOfOverflows;}
	virtual ErrCode DoNode(int32);
	void SetScale(double  Scale) { Scale_1 = Scale; parameter_changed(); }
};

extern Gain * GainDef;


#endif /* #ifdef GAIN_DOT_H */
