/*
 *  net.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef NET_DOT_H
#define NET_DOT_H
#include "ObjProUsr/buffer.h"
#include "ObjProUsr/node.h"
#include "ObjProUsr/sigbase.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/network.h"

class Network: public ProcessNet {
#line 622 "../net.usr"
 
	void replace(const char * replace_what, int retain_flag = 0,
		NodeReplacementList ** rep_ret=0);
	void replace_with_compare(int32 max_rep, double tol,
		const char * error_file, int retain_flag = 0,
		class NodeReplacementList ** rep =0);
	void save_state(const char * name, int exec_count);
	void validate_state_out(const char * prefix, const char * user_desc,
		const char * dir_name,int exec_count);
	void abort_message();
	void validate_kernel(const char * dir_name, int32 exec_count,
		int32 extra, int32 max_rep, double tolerance,const char * error_file,
		const char * Target=0, int16 Create=0);
	void write_shell_execute(const char * dir_name,const char *file_dir,int count);
	void check_redisplay();
	int do_not_redisplay ;
#line 40 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/net.h"
public:
	Network (const char * Name);
	virtual ~Network();
	virtual int CheckSafeDelete() ;
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual const char * EmitState(OutTokens& Out) ;
	void GraphDisplay ();
	void Execute (int32 InputSamples);
	void Raise ();
	void ReplaceNode (Node&ToReplace, Node&Replacement);
	void MakeTarget (const char * Target, int16 Create, 
		const char * Directory);
	void MakeValidate (const char * DirName, int32 ExecuteCount, 
		int32 ExtraCountCreator, int32 MaxReport, double Tolerance, 
		const char * errorFile);
	void TargetValidate (const char * Target, int16 Create, 
		const char * DirName, int32 ExecuteCount, 
		int32 ExtraCountCreator, int32 MaxReport, double Tolerance, 
		const char * ErrorFile);
	void SetTimingExact (int16 Exact);
	void ReplaceWithOutput ();
	void ReplaceWithCompare (int32 MaxReport, double Tolerance, 
		const char * ErrorFile);
	Network& operator+ (SignalStr&TheNode);
	Network& operator>> (Node&TheNode);
	void GraphDisplayWindow (int16 Width, int16 Height);
	void DisplayNames ();
	void SetBufferDescriptor (BufferDescript&Descriptor);
	void AssociateNode (Node&TheNode);
	Network& Link (Node&TheNode, int16 OutChannel);
	Network& SelfLink (Node&NodeOut, Node&NodeIn, int16 ChannelOut, 
		int16 ChannelIn);
	void AssignBuffers (BufferDescript&Descriptor);
	BufferDescript& GetBufferDescriptor ();
	void ClearBuffers ();
	NetControl& GetNetController ();
	void ClearNetwork ();
};

extern Network * NetworkDef;


#endif /* #ifdef NET_DOT_H */
