/*
 *  mux.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef MUX_DOT_H
#define MUX_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procnode.h"

class Mux: public ProcessNode {
	int16  Channels_1;
	int32  InputSampleSize_2;
	int32  OutputSampleSize_3;
	int16  MinimumChunk_4;
public:
	Mux (const char * Name, int16 Channels, int32 InputSampleSize, 
		int32 OutputSampleSize, int16 MinimumChunk);
	virtual ~Mux();
	int16 GetChannels() const {return Channels_1;}
	int32 GetInputSampleSize() const {return InputSampleSize_2;}
	int32 GetOutputSampleSize() const {return OutputSampleSize_3;}
	int16 GetMinimumChunk() const {return MinimumChunk_4;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
};

extern Mux * MuxDef;


#endif /* #ifdef MUX_DOT_H */
