/*
 *  tmpglob.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  tmpglob.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef TMPGLOB_DOT_H
#define TMPGLOB_DOT_H

#include "hrdarth.h"
enum NormalizeOption {NormFull, NormPower2Full, NormPower2FFTPass};
/* Normalize options are -
 * 	NormFull - magnitude of largest value is full scale
 *      NormPower2Full - data is left shifted as far as possible 
 *	NormPower2FFTPass - scaled to prevent FFT overflow
 */

void Normalize(MachWord *, int32 Size, enum NormalizeOption);
void Normalize(CxMachWord *, int32 Size, enum NormalizeOption);

// Normalize routines have NO effect on floating point data
typedef double AccOverflowCheck ;
int ArithAccCheckOverflow(AccOverflowCheck& );

int ArithCheckOverflow(OverflowCheck& );
// This routine has no effect on double precision data

// Shift in the following routines puts and added down shift factor to
// the scaling (negative Shift will scale up i. e. produce a larger result)

CxMachWord AccScale(CxAccMachWord);
MachWord AccScale(AccMachWord);
CxMachWord AccScale(CxAccMachWord,int Shift);
MachWord AccScale(AccMachWord,int Shift);

CxMachWord FullScale(complex Val);
MachWord FullScale(double Val);
CxMachWord FullScale(complex Val,int Shift);
MachWord FullScale(double Val,int Shift);

/*	Full Scale assumes Val is between 0 and 1 and scales it so 1
 *	is the largest value represented. This routine has effect on
 *	floating point data. If an overflow results this is reported.
 */ 

CxMachWord RoundDouble(complex Val);
MachWord RoundDouble(double Val);

extern const MachWord MaxPositiveValue ;
#endif /* #ifdef TMPGLOB_DOT_H */
