/*
	scale.h
*/

#define SCALE_WIDTH 70
#define SCALE_FONT "6x10"

typedef struct myscale {
	Display *dpy;
	Window frame;
	int framewidth, frameheight;	/* its dimensions 	*/
	Window win;				/* actual drawables */
	Pixmap pm;
	int topmargine, botmargine;	/* vertical margines */
	int label1x, label1y, label2x, label2y;	/* location of labels  */
	char label1[16], label2[16];
	Canvas *cnv;
	GC gc;
	XSegment *lines;			/* array of scale lines */
	int nlines, maxlines;
	int pr_len, sc_len, tr_len;	/* lengths of lines	*/
	int txt_xloc, txt_yoffset;	/* offset of scale numbering */
/* functions */
	void (*setLabels)();
	void (*drawLabels)();
	void (*plotScale)();
	void (*setVertMargines)();	
	unsigned (*scaleWidth)();
	unsigned (*scaleHeight)();
	unsigned (*frameWidth)();
	unsigned (*frameHeight)();
	void (*moveResize)();
	Pixmap (*getPix)();
	void (*display)();
	void (*destroy)();
} Scale;

typedef struct myscale_list {
	Display *dpy;
	Window frame;
	int framewidth, frameheight;	/* its dimensions 	*/
	struct myscale *list[4];
	int nchans;
	int is_mapped;		/* flag */
	void (*setLabels)();
	void (*drawLabels)();
	void (*plotScales)();
	void (*setVertMargines)();	
	unsigned (*scaleWidth)();
	unsigned (*scaleHeight)();
	unsigned (*frameWidth)();
	unsigned (*frameHeight)();
	void (*resize)();
	void (*display)();
	void (*destroy)();
	void (*addScale)();
} Mv_scale;


/* declarations for scale object functions */
void scl_setLabels(), scl_drawLabels(), scl_plotScale(), scl_setVertMargines();
void  scl_display(), scl_moveResize(), scl_destroy();
unsigned scl_scaleWidth(), scl_scaleHeight(), scl_frameWidth(), scl_frameHeight();
Pixmap scl_getPix();

/* declarations for scale list object functions */
void sclst_addScale();
void sclst_setLabels(), sclst_drawLabels(), sclst_plotScales(), sclst_setVertMargines();
void  sclst_display(), sclst_resize(), sclst_destroy();
unsigned sclst_scaleWidth(), sclst_scaleHeight(), sclst_frameWidth(), sclst_frameHeight();

