/* record.c
*/

#include "main.h"
#include "panels.h"
#ifdef NeXT
#include <sound/sound.h>
#endif
#include "nobug.h"

/* right now, hard-wiring the max record time */

#define MAXRECLEN 60

int recordDone(), recordStarted();

extern cbuf_struct *c;
extern FLAG is_buff, yesbuff;
extern Mv_panel *ctrl_panel;
extern Display *dpy;
void stop_record();
static char tmpname[28];
int recordtag;

void
record_it(p, pi)
	Panel *p;
	Panel_item *pi;
{
#ifdef NeXT
	int err, fd, size, srate, format;
	double length = MAXRECLEN;
	SNDSoundStruct *s;
	sprintf(tmpname, "/tmp/tmpsnd.%d", getpid());
	block_events();
	size = length * SND_RATE_CODEC;
	srate = SND_RATE_CODEC;
	format = SND_FORMAT_MULAW_8;
	err = SNDAlloc(&s, size, format, srate, 1, 0); 
	if (err != SND_ERR_NONE) {
		mv_alert(SNDSoundError(err));
		unlink(tmpname);
		unblock_events();
		return;
	}
	recordtag = 1;
	unblock_events();
	SNDStartRecordingFile(tmpname, s, 1, 1, 1, recordStarted, recordDone);
#endif
}

#ifdef NeXT
int
recordStarted(s, tag, err)
	SNDSoundStruct *s;
	int tag, err;
{
	DBCOM(recordStarted called);
	ctrl_panel->setItem(ctrl_panel, "Record", LXPI_PROC, stop_record);
	ctrl_panel->setItem(ctrl_panel, "Record", LXPI_STRING, " Stop "); 
	ctrl_panel->redisplay(ctrl_panel, "Record");
	block_menus();
	block_canvas();
	DBCOM(recordStarted exited);
}
	
int
recordDone(s, tag, err)
	SNDSoundStruct *s;
	int tag, err;
{
	int bufsize, size;
	SNDSoundStruct *new;
	char *ptr;
	DBCOM(recordDone called);
	recordtag = 0;
	if(err != SND_ERR_NONE) {
		mv_alert(SNDSoundError(err));
		SNDFree(s);
		unlink(tmpname);
		return;
	}
	err = SNDReadSoundfile(tmpname, &new);
	if(err != SND_ERR_NONE) {
		mv_alert(SNDSoundError(err));
		SNDFree(s);
		unlink(tmpname);
		return;
	}
	SNDGetDataPointer(new, &ptr, &bufsize, &size);
	clear_buffer();
	if(alloc_buffer((unsigned) bufsize) < 0) {
		SNDFree(new);
		SNDFree(s);
		unlink(tmpname);
		return;
	}
	bcopy(ptr, c->sfbuff, bufsize);
	c->srate = SND_RATE_CODEC;
	c->nchans = 1;
	c->size = size;
	c->nsamps = bufsize/size;
	c->is_float = False;
	is_buff = yesbuff = True;
	muToShort((ebuf_struct *) c);
	SNDFree(s);
	SNDFree(new);
	unlink(tmpname);
	ctrl_panel->setItem(ctrl_panel, "Record", LXPI_STRING, "Record"); 
	ctrl_panel->setItem(ctrl_panel, "Record", LXPI_PROC, record_it);
	ctrl_panel->redisplay(ctrl_panel, "Record");
	set_menus();
	unblock_menus();
	unblock_canvas();
	XFlush(dpy);
	DBCOM(recordDone exited);
}
#endif

void
stop_record(p, pi)
	Panel *p;
	Panel_item *pi;
{
#ifdef NeXT
	DBCOM(stop_record called);
	DBPRT(recordtag);
	if(recordtag) SNDStop(recordtag);
	DBCOM(stop_record exited);
#endif
}
