/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include "dialog.h"
#include "nobug.h"

#define OCTPT	0		/* data modes for increment */
#define LINOCT	1
#define RATIO	2


extern double array[SIZE];	/* for use with setline */
extern sf_struct *v;		/* the global struct containing much info */
extern int lineset;		/* the flag telling if setline done */
extern double tabs[2];		/* for tablei */

unsigned
phrase_set(es)
ebuf_struct *es;
{
	if(dialog->call(dialog, D_QPHRASE, "") < 1) return 0;
	/* load the value into the p array for trans to use */
	es->p[0] = dialog->getValue(dialog, 0);
	if(dialog->getChoice(dialog, 0)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	tab_set(es);	/* set up table */
	return es->bufsize;
}

mv_phrase(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
    double input[4], amp, sig[4]; 
    register int i, j, z;
    register long int outcount = 0;

	/*  p0 = amp */

    z = v->srate/8000;		      /* the control rate for amp curve */
    z = z ? z : 1;
    j = 0;

    sfreset();		/* sets buffer pointers to starting points */

    /* the processing loop for the input signal */

    while(outcount++ < a->nsamps)
    {
	GETSAMP(a, input);                 /* get input samp */ 
	while(!j--)
	{
		amp = tablei(outcount,array,tabs) * b->p[0];
		j = z;
	}
	for(i=0; i<a->nchans; i++)
	{
		sig[i] = input[i] * amp;
	}
        ADDSAMP(b, sig);
    }
}
