/* main.h --- the main include file for mixview */

#include <stdio.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <sys/stat.h>
#include <lxt.h>

#ifdef SYSV
#include <sys/fcntl.h>
#include <string.h>
#define False 0
#define True 1
#define boolean int     
#else
#include <strings.h>
#include <sys/file.h>
#include <sys/types.h>
#endif /* SYSV */

#include "sfheader.h"
#include "decl.h"

#define ROUND(x)	(int)((x)>0.0?(x)+0.5:(x)-0.5)
#define ABS(x) 		(((x)>=0)?x:-(x))
#define FABS(x) 	(((x)>=0.0)?x:-(x))

#ifdef SYSV
#define L_SET   0
#define L_INCR  1
#endif

#define CNULL	((char*)NULL)

#define YES	1
#define NO	0
#define CANCEL	-1

/* the sfbuffer reading and writing macros */

#define GETSAMP(s,a) (*getsamp[s->size])(s, a)
#define PUTSAMP(s,a) (*putsamp[s->size])(s, a)
#define ADDSAMP(s,a) (*addsamp[s->size])(s, a)

extern int (*addsamp[5])(), (*getsamp[5])(), (*putsamp[5])();

#define VSPM_WIDTH	100
#define VSPM_HEIGHT	1000

/* fonts used in display */

#define CANVAS_FONT "-adobe-times-bold-r-normal--12-*-*-*-*-*-*-*"
#define LARGE_FONT "-adobe-times-bold-r-normal--14-*-*-*-*-*-*-*"
#define TINY_FONT "6x10"

/* cursors used */

#define MAIN_CURS	XC_cross
#define ARROW_CURS	XC_left_ptr
#define WAIT_CURS	XC_watch
#define MENU_CURS	XC_hand2
#define DRAW_CURS	XC_pencil
#define CROSS_CURS	XC_tcross

/* masks for cut buffer type */

#define BUF_NONE        0
#define BUF_INT         1
#define BUF_EXT         3

#define MAXSEGS 	3200
#define MAXCOLS		1600
#define MAXARGS 	50
#define SIZE		512

typedef struct _sf_struct {
	char *sfbuff;		/* pointer to the sfbuff (to be cast later) */
	int is_float;		/* flag for all routines that read buffer */
	long nsamps;
	int nchans;
	unsigned size;		/* size of samples in bytes */
	unsigned bufsize;	/* size of buffer in bytes */
	int srate;		/* sample rate */
	double peakamp;
	Atom cutproperty;	/* the property type for file */
	double sfdur;
	int sffd;		/* file descriptor */
	SFHEADER sfh;
	char sfdir[128];
	char sfname[128];
	struct stat sfst;
	int width;
	int height;
	unsigned bwidth;	/* Graphic vertical bandwidth */
	double scale;		/* Scale of signal to graphics */
	double grainsize;	/* in samples-per-grain */
	double secgrain;	/* seconds per grain */
	long sgrain;		/* current start grain number on screen */
	long egrain;
	double stime;		/* current start and end times for screen */
	double etime;
	double itime;		/* Hairline location (time) */
} sf_struct;

typedef struct _cbuf_struct 	/* the structure for the cut-buffer */
{
	char *sfbuff;		/* edit buffer */
	int is_float;
	long nsamps;		/* the length of this buffer */
	int nchans;
	unsigned size;
	unsigned bufsize;	/* size of buffer in bytes */
	int srate;		/* sample rate */
	double peakamp;
	Atom cutproperty;	/* the property type for buffer */
	long inptr, outptr;	/* counters for I/O macros */
	double edstart;
	double edend;		/* the location of this in the soundfile */
} cbuf_struct;

typedef struct _ebuf_struct	/* the structure for the "edit package"  */
{
	char *sfbuff;		/* pointer to soundfile buffer */
	int is_float;
	long nsamps;		/* the length of this buffer */
	int nchans;		/* number of channels for soundfile */
	unsigned size;		/* size of samples in bytes  */
	unsigned bufsize;	/* size of buffer in bytes */
	int srate;		/* sample rate */
	double peakamp;
	Atom cutproperty;	/* the property type for buffer */
	long inptr, outptr;	/* counters for I/O macros */
	double p[MAXARGS];	/* parameters for all edit routines */
} ebuf_struct;

typedef struct _ext_buff { 	/* transfer property structure for buffers */
	char name[32];
	unsigned bufsize;
} ext_buff;

typedef int POINTER;
typedef unsigned short FLAG;
typedef void (*VPFun)();

#define PROC_NULL ((VPFun)NULL)

long Ngrains();
double screen_time();
double set_grainsize();

Window new_window();
