/* dialog.h -- the include file for all routines invoking the dialog wins
*/

#include "panels.h"

/* dialog window index numbers */

#define D_ALERT		0
#define D_1L2B		1
#define D_2L1B		2
#define D_2L2B		3
#define D_2L3B		4
#define D_3L2B		5
#define D_3L3B		6

#define D_FNEW		7
#define D_FOPEN		8
#define D_FSAVETO	9

#define D_QMIX		10
#define D_QREPLACE	11
#define D_QSPLICE	12
#define D_QMULT		13
#define D_QCFADE	14
#define D_QPHRASE	15
#define D_QINSERT	16
#define D_QTRANS	17
#define D_QGRAVY	18
#define D_QMELL		19
#define D_QTONE		20
#define D_QRESON	21
#define D_QCOMB		22
#define D_SFORMAT	23
#define D_SRATE		24
#define D_SFLEN		25
#define D_QRANGE	26
#define D_QAMODE	27
#define D_QGRAIN	28
#define D_QSTIMES	29
#define D_QSFDIR	30
#define D_COMCLOSE	31
#define D_SFINFO	32
#define D_QVSCALE	33
#define D_ERROR		34
#define D_QFFT		35
#define D_QLPC		36
#define D_QPTRACK	37
#define D_QSVSCALE 	38
#define D_QSHSCALE 	39
#define D_QUERY 	40

/* indices for text setup only -- not separate windows */

#define D_NOPEN		50
#define D_NHEADER	51
#define D_NBMEM		52
#define D_LENWARN	53
#define D_CONFINS	54
#define D_NEXTBUF	55
#define D_QRESCALE	56
#define D_NWHEADER	57
#define D_RONLY		58
#define D_SFEXISTS	59
#define D_FREVERT	60
#define D_SBQUIT	61
#define D_SAVWARN	62
#define D_FCLOSE	63
#define D_WASMULAW	64

typedef struct my_dialog {		/* the data object for dialog windows */
	Mv_panel *panel;
	int ret_code;
	int alert;
	void (*show)(),
	     (*moveFrame)();
	int (*code)();
	Panel *((*getPanel)()); 	/* inherited ?? */
	void (*setItem)();
	void (*addItem)();
	Panel_item *((*getItem)());	/* inherited ?? */
	Panel_item *((*getItemN)());	/* inherited ?? */
	int (*nLabels)();
	int (*nTexts)();
	int (*nButtons)();
	int (*nChoices)();
	int (*nItems)();
	void (*addLabel)();
	void (*addButton)();
	void(*setDefaultButton)();
	void (*addChoice)();
	void (*addChoiceItem)();
	void (*addText)();
	void (*setText)();
} Dialog_win;

typedef struct dialog_list {		/* object containing list of dialogs */
/* private data */
	int nwins;
	int maxwins, maxtexts, maxchoices;
	Dialog_win **list;
	Dialog_win *currentwin;
	char **text_strings;
	double *text_vals;
	int *choice_vals;
	struct override {
		int text;
		int val;
		int choice;
	} *Override;
	/* functions */
	void (*getValues)();
	int (*winIndex)();
	char *((*getText)());
	double (*getValue)();
	int (*getChoice)();
	void (*setValue)();
	void (*setChoice)();
	int (*call)();
	void (*extendList)();
	Dialog_win *((*getDialog)());
	Dialog_win *((*newDialog)());
	Dialog_win *((*addDialog)());
} Dialog;

extern Mv_panel *new_panel();
extern Dialog_win *new_dialog_win();
extern Dialog *dialog, *new_dialog_list();	/* the global dialog object */
void mv_error(), mv_alert();
