/* databuff.h	structures and objects for soundfile buffers */

typedef struct mydata {
/* private data */
	int fd;
	char *data;	
	int nchans;
	unsigned size;				/* size of units in bytes */
	unsigned datasize;			/* size of data in bytes */
	unsigned framesize;			/* put in to save calculation */
	double maxvalue[4], minvalue[4];
/* private functions */
	void (*shiftData)();	/* for splicing data segments in and out  */	
	int (*changeDataSize)();
	double (*doubleValue)();
	double (*scanForPeak)();
	int (*openFile)();
	int (*writeFile)();
/* public functions */
	int (*readFile)();
	int (*readHeader)();
	void (*setDataFormat)();
	int (*loadData)();
	unsigned (*dataSize)();
	double (*maxValue)(), (*minValue)();
	int (*nChannels)(), (*nElements)();
	struct mydata *((*copyData)());	/* creates new obj contng portion of current */
	struct mydata *((*insertData)());	
	void (*destroy)();
} Data_buff;

void db_shiftData();
int db_changeDataSize();
double db_doubleValue(), db_minValue(), db_maxValue(), db_scanForPeak();

int db_openFile(), db_readFile(), db_writeFile(), db_loadData(), db_readHeader();
unsigned db_dataSize();
int db_nChannels(), db_nElements();
Data_buff *db_copyData(), *db_insertData();
void db_destroy(), db_setDataFormat();

Data_buff *new_databuff();
