/*
	analysis.c
*/

#include "main.h"
#include "dialog.h"
#include "mesg.h"
#include "screen.h"
#include "databuff.h"
#include "datawin.h"
#include "lp.h"
#include "fft.h"

extern Display *dpy;
extern sf_struct *v;
extern cbuf_struct *c;

int
lpc_analysis(ld, display_data)
	LPDATA *ld;
	int *display_data;
{
	cbuf_struct cb;
	double start, end;
	int status = 1;
	*display_data = 0;
	if(dialog->call(dialog, D_QLPC, "") < 0) return 0;
	block_events();
	clear_events();
	ld->npoles = dialog->getValue(dialog, 0);
	ld->offset = dialog->getValue(dialog, 1);
	if(dialog->getValue(dialog, 2) > 0.0)
		ld->offset = v->srate/dialog->getValue(dialog, 2);
	ld->lpfname = dialog->getText(dialog, 3);
	ld->comment = "";
	ld->use_header = dialog->getChoice(dialog, 0);
	*display_data = dialog->getChoice(dialog, 1);
	start = (c->edstart < 0.0) ? 0 : c->edstart;
	end = (c->edend > v->sfdur) ? v->sfdur : c->edend;
	set_edit(&cb, v, start, end);
	if(!anallpc(&cb, ld)) {
		mv_alert("Sorry...LPC failed.");
		status = 0;
	}
	unblock_events();
	return status;
}

int
ptrack_analysis(ptd, display_data)
	PTDATA *ptd;
	int *display_data;
{
	cbuf_struct cb;
	double start, end;
	int status = 1;
	*display_data = 0;
	if(dialog->call(dialog, D_QPTRACK, "") < 0) return 0;
	block_events();
	clear_events();
	ptd->framesize = dialog->getValue(dialog, 0);
	ptd->offset = dialog->getValue(dialog, 1);
	if(dialog->getValue(dialog, 2) > 0.0)
		ptd->offset = v->srate/dialog->getValue(dialog, 2);
	ptd->highest = dialog->getValue(dialog, 3);
	ptd->lowest = dialog->getValue(dialog, 4);
	ptd->ptfname = dialog->getText(dialog, 5);
	*display_data = dialog->getChoice(dialog, 0);
	start = (c->edstart < 0.0) ? 0 : c->edstart;
	end = (c->edend > v->sfdur) ? v->sfdur : c->edend;
	set_edit(&cb, v, start, end);
	if(!ptrack(&cb, ptd)) {
		mv_alert( "Sorry...Pitch track failed.");
		status = 0;
	}
	unblock_events();
	return status;
}

display_fft_data(ftd)
	FFTDATA *ftd;
{
	Data_win *fft_win;
	Mv_screen *scr;
	Mv_panel *pan;
	int nchansdata = 2, npoints;
	char labelstring[128];
	mesg->On(mesg, "Reading data for display...");
	fft_win = new_datawin(ftd->fftfname);
	fft_win->setDataFormat(fft_win->data, nchansdata, sizeof(double));
	fft_win->setFrameLabel(fft_win, "Fast Fourier Transform Analysis");
	fft_win->setScanChannels(fft_win, 0, nchansdata-1);
	npoints = fft_win->data->nElements(fft_win->data, 0);
	if(!npoints) {	/* if empty file */
		fft_win->destroy(fft_win);
		mesg->Off(mesg);
		return -1;
	}
	scr = fft_win->scrn;
	scr->setScaleTitle(scr->vscale,  0, "Ampl.", ftd->mode ? "(Db.)" : "");
	scr->setScaleTitle(scr->vscale,  1, "Phase", "");
	scr->setHairLabel(scr, "freq = ");
	fft_win->setHorizValues(fft_win, 0.0, 0.5 * v->srate);
	pan = fft_win->dpanel;
	sprintf(labelstring, "%s%s", "FFT data file: ", ftd->fftfname);
	pan->addLabel(pan, 10, 10, labelstring, "filename");
	sprintf(labelstring, "%s%d", "Number of points: ", npoints);
	pan->addLabel(pan, 10, 30, labelstring, "npoints");
	pan->addButton(pan, 10, 60, 
		"refresh screen", fft_win->screen_redraw_proc);
	pan->addButton(pan, 180, 60, "fit data in window",
		fft_win->data_fit_proc);
	mesg->On(mesg, "Displaying...");
	fft_win->display(fft_win);
	mesg->Off(mesg);
	return 1;
}

display_ptrack_data(ptd)
	PTDATA *ptd;
{
	Data_win *ptrack_win;
	Mv_screen *scr;
	Mv_panel *pan;
	int nchansdata = 2;
	char labelstring[128];
	mesg->On(mesg, "Reading data for display...");
	ptrack_win = new_datawin(ptd->ptfname);
	ptrack_win->setDataFormat(ptrack_win->data, nchansdata, sizeof(float));
	ptrack_win->setFrameLabel(ptrack_win, "Pitch Track Analysis");
	ptrack_win->setScanChannels(ptrack_win, 0, nchansdata-1);
	scr = ptrack_win->scrn;
	scr->setScaleTitle(scr->vscale,  0, "Freq.", "(Hz.)");
	scr->setScaleTitle(scr->vscale,  1, "Ampl.", "RMS");
	scr->setHairLabel(scr, "frame ");
	pan = ptrack_win->dpanel;
	sprintf(labelstring, "%s%s", "Pitch track data file: ", ptd->ptfname);
	pan->addLabel(pan, 10, 10, labelstring, "filename");
	sprintf(labelstring, "%s%d", "Number of frames: ", 
		ptrack_win->data->nElements(ptrack_win->data, 0));
	pan->addLabel(pan, 10, 30, labelstring, "frames");
	pan->addButton(pan, 10, 60, 
		"refresh screen", ptrack_win->screen_redraw_proc);
	pan->addButton(pan, 180, 60, "fit data in window",
		ptrack_win->data_fit_proc);
	mesg->On(mesg, "Displaying...");
	ptrack_win->display(ptrack_win);
	mesg->Off(mesg);
	return 1;
}

display_lpc_data(lpd)
	LPDATA *lpd;
{
	Data_win *lpc_win;
	Mv_screen *scr;
	Mv_panel *pan;
	char labelstring[128];
	int nchansdata = lpd->npoles + 4;
	mesg->On(mesg, "Reading data for display...");
	lpc_win = new_datawin(lpd->lpfname);
	lpc_win->setDataFormat(lpc_win->data, nchansdata, sizeof(float));
	lpc_win->setFrameLabel(lpc_win, "LPC Analysis");
	if(lpc_win->setScanChannels(lpc_win, 0, 3) < 0) {
		mesg->Off(mesg);
		return -1;
	}
	scr = lpc_win->scrn;
	scr->setScaleTitle(scr->vscale,  0, "RMS 2", "");
	scr->setScaleTitle(scr->vscale,  1, "RMS 1", "");
	scr->setScaleTitle(scr->vscale,  2, "Error", "");
	scr->setScaleTitle(scr->vscale,  3, "Freq.", "(Hz.)");
	scr->setHairLabel(scr, "frame ");
	pan = lpc_win->dpanel;
	sprintf(labelstring, "%s%s", "LPC data file: ", lpd->lpfname);
	pan->addLabel(pan, 10, 10, labelstring, "filename");
	sprintf(labelstring, "%s%d", "Number of frames: ", 
		lpc_win->data->nElements(lpc_win->data, 0));
	pan->addLabel(pan, 10, 30, labelstring, "frames");
	pan->addButton(pan, 10, 60, "refresh screen", 	
		lpc_win->screen_redraw_proc);
	pan->addButton(pan, 180, 60, "fit data in window",
		lpc_win->data_fit_proc);
	mesg->On(mesg, "Displaying...");
	lpc_win->display(lpc_win);
	mesg->Off(mesg);
	return 1;
}
