#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <ctype.h>
#include <math.h>

#include "lxt.h"

extern char *xvt_pastebuf;
extern int xvt_pastebufsz;

extern Void *lxt_selsrc;
extern Void *lxt_seldest;
extern int lxt_seldesttype;

void
textsw_copyproc(m, mi)
/*
   Internal function.
   Copy highlighted text into the paste buffer.
*/
Menu *m;
Menu_item *mi;
{
	Textsw *t;
	Atom prop;
	Time tmstamp;
	Atom tmatom;
	int i;
	XEvent evt;

	t= (Textsw *) m->xm_clientdata;

	/* we need to generate a real timestamp to pass to
	   XConvertSelection() to maintain ICCCM compliance --
	   this is done by performing a zero-length append
	   to a window property; if this fails, just use
	   CurrentTime and be happy that we tried */
	if ((tmatom= XInternAtom(t->xt_dpy, "_LXT_ICCCM_TMSTAMP", False)) == None)
		tmstamp= CurrentTime;
	else {
		XChangeProperty(t->xt_dpy, t->xt_twin, tmatom, XA_STRING, 8, PropModeAppend, (unsigned char *) NULL, 0);
		XSync(t->xt_dpy, False);

		/* wait 5 seconds max to get notification, then give up */
		for (i= 5; i > 0; i--) {
			if (XCheckTypedWindowEvent(t->xt_dpy, t->xt_twin, PropertyNotify, &evt) == True)
				break;
			else
				sleep(1);
		}
		if (i > 0)
			tmstamp= ((XPropertyEvent *) &evt)->time;
		else
			tmstamp= CurrentTime;
	}

	lxt_seldest= (Void *) t;
	lxt_seldesttype= LX_TEXTSW;
	prop= XInternAtom(t->xt_dpy, LX_SELATOM, False);
	XConvertSelection(t->xt_dpy, XA_PRIMARY, XA_STRING, prop, t->xt_twin, tmstamp);

	return;
}

void
textsw_cutproc(m, mi)
/*
   Internal function.
   Copy highlighted text into the paste buffer
   and delete it from the textsw.
*/
Menu *m;
Menu_item *mi;
{
	Textsw *t;
	int begin_line, begin_char, end_char;
	void lxt_clearsel();
	void textsw_draw(), textsw_display();
	void textsw_drawscrolls();

	t= (Textsw *) m->xm_clientdata;

	if (!t->xt_drawhlt || !t->xt_allowinput) {
		XBell(t->xt_dpy, 10);
		return;
	}
	if (textsw_grabhlttext(t, &xvt_pastebuf, &xvt_pastebufsz, FALSE, &begin_line, &begin_char, &end_char) != LX_SUCCESS)
		return;

	/* if the user cut text that was above the top line in the window,
	   then the top line in the window must be adjusted */
	if (begin_line < t->xt_topline) {
		t->xt_topline= begin_line - 10;
		if(t->xt_topline < 0)
			t->xt_topline= 0;
	}

	bcopy(&(t->xt_text[end_char + 1]),  &(t->xt_text[begin_char]), (t->xt_nbufchars - 1) - end_char);
	t->xt_nbufchars-= end_char - begin_char + 1;

	textsw_cleanuptext(t);
	
	t->xt_drawhlt= FALSE;
	t->xt_drawcursor= FALSE;

	textsw_draw(t);
	textsw_display(t);
	t->xt_textedited= TRUE;
	textsw_longestline(t);
	textsw_drawscrolls(t);

	if (t == (Textsw *) lxt_selsrc)
		lxt_clearsel(FALSE);

	return;
}

void
textsw_pasteproc(menu, mi)
Menu *menu;
Menu_item *mi;
{
	Textsw *t;
	int xvt_pastebuf_lines, i;
	void lxt_clearsel();
	void textsw_draw(), textsw_display();
	void textsw_drawscrolls();

	t= (Textsw *) menu->xm_clientdata;
	if (!t->xt_drawcursor || (xvt_pastebuf == (char *) NULL) || !t->xt_allowinput) {
		XBell(t->xt_dpy, 10);
		return;
	}

	/* count lines in paste buffer	*/
	xvt_pastebuf_lines= 0;
	for (i= 0; i < xvt_pastebufsz; i++) {
		if (xvt_pastebuf[i] == '\0')
			++xvt_pastebuf_lines;
	}

	if (t->xt_textbufsz < t->xt_nbufchars+xvt_pastebufsz+LXT_TEXTBUFINC) {
		t->xt_text= realloc(t->xt_text, (unsigned) ((t->xt_nbufchars+xvt_pastebufsz+LXT_TEXTBUFINC)*sizeof(char)));
		t->xt_textbufsz= t->xt_nbufchars+xvt_pastebufsz+LXT_TEXTBUFINC;
	}

	bcopy(&(t->xt_text[t->xt_ichar]), &(t->xt_text[t->xt_ichar]) + xvt_pastebufsz, t->xt_nbufchars - t->xt_ichar);
	bcopy(xvt_pastebuf, &(t->xt_text[t->xt_ichar]), xvt_pastebufsz);

	t->xt_nbufchars+= xvt_pastebufsz;

	textsw_cleanuptext(t);
	
	t->xt_drawhlt= FALSE;
	if (t == (Textsw *) lxt_selsrc)
		lxt_clearsel(FALSE);
	t->xt_drawcursor= FALSE;

	textsw_draw(t);
	textsw_display(t);
	t->xt_textedited= TRUE;
	textsw_longestline(t);
	textsw_drawscrolls(t);
}

int
textsw_grabhlttext(t, buf, bufsz, nullterm, bl, bc, ec)
/*
   Internal function.
   Grabs any highlighted text and copies it into a buffer.
*/
Textsw *t;
char **buf;
int *bufsz;
boolean nullterm;
int *bl, *bc, *ec;
{
	int begin_line, end_line;
	int begin_char, end_char, begin_pixel, end_pixel;
	int temp1, temp2;
	char *c;

	if (!t->xt_drawhlt) {
		XBell(t->xt_dpy, 10);
		return(LX_ERROR);
	}

	begin_line= t->xt_topline + t->xt_cursorpy/t->xt_cheight;
	begin_pixel= (t->xt_leftpix + t->xt_cursorpx);
	begin_char= textsw_adjchar(t, begin_line, begin_pixel);
	end_line= t->xt_topline + t->xt_hltstarty/t->xt_cheight;
	end_pixel= (t->xt_leftpix + t->xt_hltstartx);
	end_char= textsw_adjchar(t, end_line, end_pixel);

	*bufsz= (t->xt_linestarts[end_line] + end_char) - (t->xt_linestarts[begin_line] + begin_char);
	if (*bufsz < 0) {
		temp1= begin_line;
		temp2= begin_char;
		begin_line= end_line;
		begin_char= end_char;
		end_line= temp1;
		end_char= temp2;
		*bufsz= -(*bufsz);
	}

	if (begin_line < 0) {
		begin_line= 0;
		begin_char= 0;
		t->xt_hltstartx= 0;
		t->xt_hltstarty= 0;
	}
	if (end_line > (t->xt_nbuflines - 1)) {
		end_line= t->xt_nbuflines;
		end_char= t->xt_linestarts[t->xt_nbuflines] - t->xt_linestarts[t->xt_nbuflines - 1];
		t->xt_hltendx= t->xt_atw;
		t->xt_hltendy= t->xt_ath;
	}

	if (*buf != (char *) NULL) {
		cfree(*buf);
		*buf= (char *) NULL;
	}

	if (nullterm == TRUE) {
		if ((*buf= calloc((unsigned) (*bufsz+1), sizeof(char))) == (char *) NULL) {
			*bufsz= 0;
			return(LX_ERROR);
		}
	}
	else {
		if ((*buf= calloc((unsigned) (*bufsz+20), sizeof(char))) == (char *) NULL) {
			*bufsz= 0;
			return(LX_ERROR);
		}
	}

	bcopy(&(t->xt_text[t->xt_linestarts[begin_line] + begin_char]), *buf, *bufsz);
	if (nullterm == TRUE) {
		c= *buf;
		c[*bufsz]= '\0';
	}

	*bc= t->xt_linestarts[begin_line] + begin_char;
	*ec= t->xt_linestarts[end_line] + end_char - 1;
	if (*bc < 0)
		*bc= 0;
	if (*ec < *bc)
		*ec= *bc;
	*bl= begin_line;

	return(LX_SUCCESS);
}

textsw_adjchar(t, line, pixel)
Textsw *t;
int line;
int pixel;
{
	int i, map[512], length, new_length;
	int full_line_length, char_in_in_str, char_in_out_str;
	int return_value;
	char s[512];

	if (t->xt_nbuflines == 0)
		return(0);

	length= t->xt_linestarts[line + 1] - t->xt_linestarts[line];

	if (t->xt_nbuflines != 0)
		textsw_expand_string(&(t->xt_text[t->xt_linestarts[line]]), s, map, length, &new_length);

	/* no text - gives a blank string */
	else {
		s[0]= '\0';
		new_length= 0;
	}

	full_line_length= XTextWidth(t->xt_font, s, new_length);
	if (pixel >= full_line_length) {
		return_value= t->xt_linestarts[line+1]-t->xt_linestarts[line];
		return(return_value);
	}

	char_in_out_str= (-1);
	for (i= 0; i <= strlen(s)-1; i++) {
		if (i == 0) {
			if (pixel < XTextWidth(t->xt_font, s, 1)/2) {
				char_in_out_str= 0;
				break;
			}
			else if (pixel <= XTextWidth(t->xt_font, s, 1)) {
				char_in_out_str= 1;
				break;
			}
		}
		else if ((pixel >  XTextWidth(t->xt_font, s, i)) && 
			 (pixel <= XTextWidth(t->xt_font, s, i+1))) {
			char_in_out_str= i+1;
			break;
		}
	}

	if (char_in_out_str == (-1))
		return(0);

	char_in_in_str= map[char_in_out_str];

	return(char_in_in_str);
}

textsw_cleanuptext(t)
Textsw *t;
{
	int i, j;
	int start, end;

	/* recalculate cursor insertion point */
	start= t->xt_linestarts[t->xt_irow];
	end= start+t->xt_icol;
	t->xt_icol= 0;
	for (i= start; i < end; i++) {
		if (t->xt_text[i] != LXT_SPHOLDER)
			t->xt_icol++;
	}

	/* get rid of space holders and reallocate
	   the text and line starts arrays */
	j= 0;
	for (i= 0; i < t->xt_nbufchars; i++) {
		if (t->xt_text[i] != LXT_SPHOLDER)
			t->xt_text[j++]= t->xt_text[i];
	}

	t->xt_nbufchars= j;
	t->xt_nspholders= 0;
	t->xt_textbufsz= t->xt_nbufchars + LXT_TEXTBUFINC;
	t->xt_text= realloc(t->xt_text, (unsigned) (t->xt_textbufsz*sizeof(char)));

	/* count the number of lines in the text */
	t->xt_nbuflines= 0;
	for (i= 1; i < t->xt_nbufchars; i++)
		if (t->xt_text[i-1] == '\0')
			++t->xt_nbuflines;

	t->xt_lsbufsz= t->xt_nbuflines + LXT_LSBUFINC;
	t->xt_linestarts= (int *) realloc((char *) t->xt_linestarts, (unsigned) (t->xt_lsbufsz*sizeof(int)));
	
	/* calculate the line starts */
	if (t->xt_nbufchars > 0) {
		t->xt_linestarts[0]= 0;
		t->xt_nbuflines= 1;
	}

	for (i= 1; i < t->xt_nbufchars; i++) {
		if (t->xt_text[i-1] == '\0') {
			t->xt_linestarts[t->xt_nbuflines]= i;
			++t->xt_nbuflines;
		}
	}

	t->xt_linestarts[t->xt_nbuflines]= t->xt_nbufchars;
	t->xt_ichar= t->xt_linestarts[t->xt_irow]+t->xt_icol;
}

textsw_gethltend(t, er, ec)
int *er, *ec;
Textsw *t;
{
	int x, y, end_x, end_y, x_offset, y_offset;
	int col2, save_flag, save_x, save_y;
	boolean textsw_compute_cursor_pos();

	if (!t->xt_drawhlt) {
		*er= *ec= -1;
		return;
	}

	end_x= t->xt_hltstartx;
	end_y= t->xt_hltstarty;

	x_offset= t->xt_leftpix - t->xt_hltorigin.x;
	y_offset= (t->xt_topline * t->xt_cheight) - t->xt_hltorigin.y;

	x= end_x - x_offset;
	y= end_y - y_offset;
	
	save_x= t->xt_cursorpx;
	save_y= t->xt_cursorpy;
	save_flag= t->xt_drawcursor;
	t->xt_cursorpx= x;
	t->xt_cursorpy= y;

	t->xt_drawcursor= TRUE;
	(void) textsw_compute_cursor_pos(t, er, ec, &col2);

	t->xt_cursorpx= save_x;
	t->xt_cursorpy= save_y;
	t->xt_drawcursor= save_flag;
}
