#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "lxt.h"

Void *lxt_selsrc= (Void *) NULL;
int lxt_selsrctype= LX_NULL;
Time lxt_selsrctm;
char *lxt_selsrcbuf= (char *) NULL;
Panel *lxt_selsrcpanel= (Panel *) NULL;

Void *lxt_seldest= (Void *) NULL;
int lxt_seldesttype= LX_NULL;

char *
lxt_getsel(dpy, win)
Display *dpy;
Window win;
{
	Atom prop, type;
	int format;
	long long_offset, longs_unread;
	unsigned long nitems, rem;
	long bytes_read, curr_read;
	unsigned char *propbuf;
	char *selbuf, *oldselbuf, *c;

	prop= XInternAtom(dpy, LX_SELATOM, False);
	bytes_read= 0;
	long_offset= 0;
	longs_unread= LX_SELTRANSFERSZ;
	selbuf= (char *) NULL;

	for (;;) {
		if (XGetWindowProperty(dpy, win, prop, long_offset, longs_unread, True, XA_STRING, &type, &format, &nitems, &rem, &propbuf) != Success)
			return(selbuf);
		if (type != XA_STRING)
			return(selbuf);

		curr_read= (long) nitems;
		if (curr_read == 0) {
			if (rem > 0)
				continue;
			else
				return(selbuf);
		}

		/* here with a successful read */
		oldselbuf= selbuf;
		if ((selbuf= calloc((unsigned) (bytes_read+curr_read+1), sizeof(char))) == (char *) NULL)
			return(oldselbuf);
		if (oldselbuf != (char *) NULL) {
			bcopy(oldselbuf, selbuf, (int) bytes_read);
			cfree(oldselbuf);
		}
		c= selbuf+bytes_read;
		bcopy((char *) propbuf, c, (int) curr_read);
		XFree((char *) propbuf);
		if (rem == 0)
			return(selbuf);

		/* here with more bytes left to be read */
		bytes_read+= curr_read;

		/* read must begin on a 32-bit boundary */
		bytes_read-= bytes_read%4;

		long_offset= bytes_read/4;
		longs_unread= rem/4;
		if (rem%4 > 0)
		longs_unread++;
		if (longs_unread > LX_SELTRANSFERSZ)
			longs_unread= LX_SELTRANSFERSZ;
	}
}

void
lxt_sendsel(dpy, evt)
Display *dpy;
XSelectionRequestEvent *evt;
{
	Atom prop;
	XSelectionEvent sevt;
	void lxt_denysel();

	if (evt->target != XA_STRING) {
		lxt_denysel(dpy, evt);
		return;
	}

	if (evt->property != None)
		prop= evt->property;
	else
		prop= evt->target;

	XChangeProperty(dpy, evt->requestor, prop, XA_STRING, 8, PropModeReplace, (unsigned char *) lxt_selsrcbuf, (int) strlen(lxt_selsrcbuf));

	sevt.type= SelectionNotify;
	sevt.send_event= True;
	sevt.display= evt->display;
	sevt.requestor= evt->requestor;
	sevt.selection= evt->selection;
	sevt.target= evt->target;
	sevt.property= prop;
	sevt.time= evt->time;

	XSendEvent(dpy, evt->requestor, True, (unsigned long) 0, (XEvent *) &sevt);

	return;
}

void
lxt_denysel(dpy, evt)
/*
   Internal function.
   Send a message to the selection requestor
   indicating that the request cannot be satisfied.
*/
Display *dpy;
XSelectionRequestEvent *evt;
{
	XSelectionEvent sevt;

	sevt.type= SelectionNotify;
	sevt.send_event= True;
	sevt.display= evt->display;
	sevt.requestor= evt->requestor;
	sevt.selection= evt->selection;
	sevt.target= evt->target;
	sevt.property= None;
	sevt.time= evt->time;

	XSendEvent(dpy, evt->requestor, True, (unsigned long) 0, (XEvent *) &sevt);

	return;
}

void
lxt_clearsel(redraw)
/*
   Internal function.
   Voluntarily relinquish ownership of selection.
*/
boolean redraw;
{
	xp_text *xpt;
	Textsw *t;
	void xptext_drw_proc(), xpi_std_dsp_proc();

	if (lxt_selsrc == (Void *) NULL)
		return;

	switch (lxt_selsrctype) {
	case LX_PANELITEM:
		if (XGetSelectionOwner(lxt_selsrcpanel->xp_dpy, XA_PRIMARY) == lxt_selsrcpanel->xp_pwin)
			XSetSelectionOwner(lxt_selsrcpanel->xp_dpy, XA_PRIMARY, None, CurrentTime);
		xpt= &(((Panel_item *) lxt_selsrc)->xpi_item.xpi_text);
		xpt->xptext_selstart= xpt->xptext_selstop= xpt->xptext_ipos;
		xpt->xptext_flags&= ~LXPTEXT_SELHOLDER;
		if ((lxt_selsrcpanel->xp_flags & LXP_PANELVISIBLE) &&
		    (lxt_selsrcpanel->xp_flags & LXP_FRAMEMAPPED) &&
		    (redraw == TRUE)) {
			xptext_drw_proc(lxt_selsrcpanel, (Panel_item *) lxt_selsrc);
			xpi_std_dsp_proc(lxt_selsrcpanel, (Panel_item *) lxt_selsrc);
		}
		lxt_selsrcpanel= (Panel *) NULL;
		break;
	case LX_TEXTSW:
		t= (Textsw *) lxt_selsrc;
		if (XGetSelectionOwner(t->xt_dpy, XA_PRIMARY) == t->xt_twin)
			XSetSelectionOwner(t->xt_dpy, XA_PRIMARY, None, CurrentTime);
		if ((t->xt_flags & LXT_FRAMEMAPPED) &&
		    (t->xt_drawhlt == TRUE) &&
		    (redraw == TRUE)) {
			textsw_drawhlt(t, TRUE, (boolean *) NULL);
			t->xt_drawhlt= FALSE;
		}
		break;
	default:
		return;
	}

	lxt_selsrc= (Void *) NULL;
	lxt_selsrctype= LX_NULL;
	lxt_selsrctm= (Time) 0;
	if (lxt_selsrcbuf != (char *) NULL) {
		cfree(lxt_selsrcbuf);
		lxt_selsrcbuf= (char *) NULL;
	}

	return;
}
