#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern boolean xp_fullredraw;

int
xpbutton_idef_proc(p, pi)
/*
   Internal function.
   Initialize defaults for a button item.
*/
Panel *p;
Panel_item *pi;
{
	pi->xpi_item.xpi_button.xpbutton_hmargin= LXPDEF_BUTTONHMARGIN;
	pi->xpi_item.xpi_button.xpbutton_vmargin= LXPDEF_BUTTONVMARGIN;
	return(LX_SUCCESS);
}

int
xpbutton_dst_proc(pi)
/*
   Internal function.
   Destroys a button item.
*/
Panel_item *pi;
{
	if (pi->xpi_item.xpi_button.xpbutton_procpm != None)
		XFreePixmap(pi->xpi_dpy, pi->xpi_item.xpi_button.xpbutton_procpm);
	if (pi->xpi_item.xpi_button.xpbutton_bgc != None)
		XFreeGC(pi->xpi_dpy, pi->xpi_item.xpi_button.xpbutton_bgc);
	return(LX_SUCCESS);
}

int
xpbutton_sz_proc(p, pi)
/*
   Internal function.
   Sizes a button item.
*/
Panel *p;
Panel_item *pi;
{
	int font_ht;

	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "xpbutton_sz_proc: null panel\n");
		return(LX_ERROR);
	}
	if (pi == (Panel_item *) NULL) {
		(void) fprintf(stderr, "xpbutton_sz_proc: null item\n");
		return(LX_ERROR);
	}
	pi->xpi_w= pi->xpi_h= 0;
	if (pi->xpi_image != (XImage *) NULL) {
		pi->xpi_w= pi->xpi_image->width;
		pi->xpi_h= pi->xpi_image->height;
	}
	else if (pi->xpi_str != (char *) NULL) {
		font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;
		pi->xpi_w= XTextWidth(pi->xpi_font, pi->xpi_str, strlen(pi->xpi_str))+(2*pi->xpi_item.xpi_button.xpbutton_hmargin)+4;
		pi->xpi_h= font_ht+(2*pi->xpi_item.xpi_button.xpbutton_vmargin)+4;
	}
	return(LX_SUCCESS);
}

void
xpbutton_drw_proc(p, pi)
/*
   Internal function.
   Plots a button item onto the backing store.
*/
Panel *p;
Panel_item *pi;
{
	int x, y, w, h;

	if (!xp_fullredraw)
		XFillRectangle(p->xp_dpy, p->xp_ppm, pi->xpi_cgc, pi->xpi_x, pi->xpi_y, pi->xpi_w, pi->xpi_h);
	if (pi->xpi_state == LXPI_INACTIVE)
		return;

	/* attempt to draw xpi_image */
	if (pi->xpi_image != (XImage *) NULL) {
		XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_image, 0, 0, pi->xpi_x, pi->xpi_y, pi->xpi_image->width, pi->xpi_image->height);
		return;
	}

	if (pi->xpi_str == (char *) NULL)
		return;
	if (strlen(pi->xpi_str) == 0)
		return;

	x= pi->xpi_x;
	y= pi->xpi_y;
	w= pi->xpi_w;
	h= pi->xpi_h;
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+3, y, x+w-4, y);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+2, y+1, x+w-3, y+1);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-4, y+2);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-3, y+2);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-3, y+3);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-2, y+2, x+w-2, y+h-3);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-1, y+3, x+w-1, y+h-4);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-3, y+h-4);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-3, y+h-3);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+w-4, y+h-3);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+2, y+h-2, x+w-3, y+h-2);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+3, y+h-1, x+w-4, y+h-1);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+3, y+h-3);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+2, y+h-3);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+2, y+h-4);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+1, y+2, x+1, y+h-3);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y+3, x, y+h-4);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+2, y+3);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+2, y+2);
	XDrawPoint(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+3, y+2);
	x= pi->xpi_x+pi->xpi_item.xpi_button.xpbutton_hmargin+2;
	y= pi->xpi_y+pi->xpi_font->max_bounds.ascent+pi->xpi_item.xpi_button.xpbutton_vmargin+2;
	XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y, pi->xpi_str, strlen(pi->xpi_str));
	return;
}

void
xpbutton_bp_proc(p, pi, evt)
/*
   Internal function.
   Process button press on button item.
*/
Panel *p;
Panel_item *pi;
XButtonPressedEvent *evt;
{
	p->xp_selitem= pi;
	p->xp_flags|= LXP_SELACTIVE;
	XFillRectangle(p->xp_dpy, p->xp_pwin, p->xp_igc, pi->xpi_x-p->xp_vx, pi->xpi_y-p->xp_vy, pi->xpi_w, pi->xpi_h);
	XFlush(p->xp_dpy);
	return;
}

void
xpbutton_br_proc(p, pi, evt)
/*
   Internal function.
   Process button release while a button item is selected.
*/
Panel *p;
Panel_item *pi;
XButtonReleasedEvent *evt;
{
	void xpbutton_drw_proc(), xpi_std_dsp_proc();

	if (pi != p->xp_selitem) {
		if (p->xp_flags & LXP_SELACTIVE) {
			XFillRectangle(p->xp_dpy, p->xp_pwin, p->xp_igc, p->xp_selitem->xpi_x-p->xp_vx, p->xp_selitem->xpi_y-p->xp_vy, p->xp_selitem->xpi_w, p->xp_selitem->xpi_h);
			XFlush(p->xp_dpy);
		}
	}
	else {
		if (p->xp_flags & LXP_SELACTIVE) {
			XFillRectangle(p->xp_dpy, p->xp_pwin, p->xp_igc, p->xp_selitem->xpi_x-p->xp_vx, p->xp_selitem->xpi_y-p->xp_vy, p->xp_selitem->xpi_w, p->xp_selitem->xpi_h);
			XFillRectangle(p->xp_dpy, p->xp_pwin, p->xp_selitem->xpi_item.xpi_button.xpbutton_bgc, p->xp_selitem->xpi_x-p->xp_vx, p->xp_selitem->xpi_y-p->xp_vy, p->xp_selitem->xpi_w, p->xp_selitem->xpi_h);
			XFlush(p->xp_dpy);

			/* set timestamp and call application-defined procedure */
			bcopy((char *) &(evt->time), (char *) &(pi->xpi_timestamp), sizeof(Time));
			if (p->xp_selitem->xpi_proc != (void (*)()) NULL)
				(*(p->xp_selitem->xpi_proc))(p, p->xp_selitem);

 			/* if item not already deselected, redraw it;
			   deselection should happen only if the application
			   is doing something in the button's xpi_proc
			   like reconfiguring the panel or doing nested event
			   handling -- neither of these are really supported,
			   but this test will guard against some problems */
 			if (p->xp_selitem != (Panel_item *) NULL) {
 				xpbutton_drw_proc(p, p->xp_selitem);
 				xpi_std_dsp_proc(p, p->xp_selitem);
 			}

			XFlush(p->xp_dpy);
		}
	}
	p->xp_selitem= (Panel_item *) NULL;
	p->xp_flags&= ~LXP_SELACTIVE;
	return;
}

void
xpbutton_pm_proc(p, pi, evt)
/*
   Internal function.
   Process pointer motion while a button item is selected.
*/
Panel *p;
Panel_item *pi;
XPointerMovedEvent *evt;
{
	if (pi != p->xp_selitem) {
		if (p->xp_flags & LXP_SELACTIVE) {
			p->xp_flags&= ~LXP_SELACTIVE;
			XFillRectangle(p->xp_dpy, p->xp_pwin, p->xp_igc, p->xp_selitem->xpi_x-p->xp_vx, p->xp_selitem->xpi_y-p->xp_vy, p->xp_selitem->xpi_w, p->xp_selitem->xpi_h);
			XFlush(p->xp_dpy);
		}
	}
	else {
		if (!(p->xp_flags & LXP_SELACTIVE)) {
			p->xp_flags|= LXP_SELACTIVE;
			XFillRectangle(p->xp_dpy, p->xp_pwin, p->xp_igc, p->xp_selitem->xpi_x-p->xp_vx, p->xp_selitem->xpi_y-p->xp_vy, p->xp_selitem->xpi_w, p->xp_selitem->xpi_h);
			XFlush(p->xp_dpy);
		}
	}
	return;
}
