#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "lxt.h"

Panel *xp_blocked= (Panel *) NULL;
int xp_blockretval;

int
panel_block(p, val)
/*
   User-callable.
   Displays a blocking panel.
*/
Panel *p;
int *val;
{
	XSetWindowAttributes xswa;
	XWindowAttributes xwa;
	Colormap cmap;
	Time tmstamp;
	Atom tmatom;
	int i, poll;
	long sleeptm;
	XEvent evt;
	Bool panel_anyevt();

	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "panel_block: null panel\n");
		return(LX_ERROR);
	}
	if (p->xp_magic != LX_PANEL) {
		(void) fprintf(stderr, "panel_block: object is not a panel\n");
		return(LX_ERROR);
	}
	if (xp_blocked != (Panel *) NULL) {
		(void) fprintf(stderr, "panel_block: blocked panel already displayed\n");
		return(LX_ERROR);
	}
	xp_blocked= p;

	/* the following call is used only to retrieve p->xp_win's colormap --
	   it was originally placed inside the following if statement just
	   before the colormap installation code, but this seemed to exercise
	   a bug in Sun's OpenWindow's server in combination with the
	   call to XGrabPointer() which formerly preceded it */
	XGetWindowAttributes(p->xp_dpy, p->xp_win, &xwa);

	xswa.override_redirect= TRUE;
	XChangeWindowAttributes(p->xp_dpy, p->xp_win, CWOverrideRedirect, &xswa);
	XMapRaised(p->xp_dpy, p->xp_win);
	if (p->xp_flags & LXP_GRABPTR) {
		XGrabPointer(p->xp_dpy, p->xp_win, True,
			ButtonPressMask | ButtonReleaseMask | PointerMotionMask,
			GrabModeAsync, GrabModeAsync, p->xp_win, None, CurrentTime);

		/* install non-default colormap if necessary */
		cmap= DefaultColormap(p->xp_dpy, DefaultScreen(p->xp_dpy));
		if (xwa.colormap != cmap)
			XInstallColormap(p->xp_dpy, xwa.colormap);
	}

	/* we need to generate a real timestamp to pass to
	   XSetInputFocus() to maintain ICCCM compliance --
	   this is done by performing a zero-length append
	   to a window property; if this fails, just use
	   CurrentTime and be happy that we tried */
	if ((tmatom= XInternAtom(p->xp_dpy, "_LXT_ICCCM_TMSTAMP", False)) == None)
		tmstamp= CurrentTime;
	else {
		XChangeProperty(p->xp_dpy, p->xp_pwin, tmatom, XA_STRING, 8, PropModeAppend, (unsigned char *) NULL, 0);
		XSync(p->xp_dpy, False);

		/* wait 5 seconds max to get notification, then give up */
		for (i= 5; i > 0; i--) {
			if (XCheckTypedWindowEvent(p->xp_dpy, p->xp_pwin, PropertyNotify, &evt) == True)
				break;
			else
				sleep(1);
		}
		if (i > 0)
			tmstamp= ((XPropertyEvent *) &evt)->time;
		else
			tmstamp= CurrentTime;
	}
	XSetInputFocus(p->xp_dpy, p->xp_win, RevertToParent, tmstamp);

	if (p->xp_alarmint > 0) {
		if (p->xp_alarmproc != (void (*)()) NULL)
			(*(p->xp_alarmproc))(p);
		else
			XBell(p->xp_dpy, 100);
		sleeptm= p->xp_alarmint*1000000;
		poll= 0;
	}

	for (;;) {

		/* standard processing */
		if (p->xp_alarmint <= 0) {
			XNextEvent(p->xp_dpy, &evt);
			if (panel_suppressevt(p, (XAnyEvent *) &evt) == TRUE)
				continue;
			if (lxt_event(&evt)) {
				if (xp_blocked == (Panel *) NULL)
					break;
			}
			else if (p->xp_proc != (void (*)()) NULL)
				(*(p->xp_proc))(&evt);
		}

		/* if an alarm is specified, ring the bell every
		   p->xp_alarmint seconds after the last event */
		else {
			boolean inactive;

			inactive= TRUE;
			if (XCheckIfEvent(p->xp_dpy, &evt, panel_anyevt, (char *) NULL) == True) {
				if (panel_suppressevt(p, (XAnyEvent *) &evt) == TRUE)
					continue;

				inactive= FALSE;
				if (lxt_event(&evt)) {
					if (xp_blocked == (Panel *) NULL)
						break;
				}
				else if (p->xp_proc != (void (*)()) NULL)
					(*(p->xp_proc))(&evt);
				sleeptm= p->xp_alarmint*1000000;
			}
			if (inactive == TRUE) {
				poll++;
				if (poll == 10) {
					poll= 0;
					usleep((unsigned) 100000);
					if ((sleeptm-= 100000) == 0) {
						sleeptm= p->xp_alarmint*1000000;
						if (p->xp_alarmproc != (void (*)()) NULL)
							(*(p->xp_alarmproc))(p);
						else
							XBell(p->xp_dpy, 100);
					}
				}
			}
		}
	}

	if (p->xp_flags & LXP_GRABPTR) {
		if (xwa.colormap != cmap)
			XUninstallColormap(p->xp_dpy, xwa.colormap);
		XUngrabPointer(p->xp_dpy, CurrentTime);
	}
	XUnmapWindow(p->xp_dpy, p->xp_win);
	xswa.override_redirect= FALSE;
	XChangeWindowAttributes(p->xp_dpy, p->xp_win, CWOverrideRedirect, &xswa);
	XSync(p->xp_dpy, False);
	*val= xp_blockretval;
	return(LX_SUCCESS);
}

boolean
panel_suppressevt(p, xa)
/*
   Internal routine.
   Returns TRUE if passed any mouse or keyboard event
   that is not directed to the blocking panel.
*/
Panel *p;
XAnyEvent *xa;
{
	if ((xa->window != p->xp_win) && (xa->window != p->xp_pwin) &&
	    (xa->window != p->xp_vswin) && (xa->window != p->xp_hswin) &&
	    (xa->type == KeyPress || xa->type == KeyRelease ||
	     xa->type == ButtonPress || xa->type == ButtonRelease ||
	     xa->type == MotionNotify)) 
		return(TRUE);
	else
		return(FALSE);
}
 
Bool
panel_anyevt(dpy, evt, arg)
Display *dpy;
XEvent *evt;
char *arg;
{
	return(True);
}

int
panel_unblock(p, val)
/*
   User-callable.
   Unblocks an active blocking panel.
*/
Panel *p;
int val;
{
	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "panel_unblock: null panel\n");
		return(LX_ERROR);
	}
	if (p->xp_magic != LX_PANEL) {
		(void) fprintf(stderr, "panel_unblock: object is not a panel\n");
		return(LX_ERROR);
	}
	if (xp_blocked == (Panel *) NULL) {
		(void) fprintf(stderr, "panel_unblock: no existing blocked panel\n");
		return(LX_ERROR);
	}
	else if (xp_blocked != p) {
		(void) fprintf(stderr, "panel_unblock: panel is not blocked\n");
		return(LX_ERROR);
	}
	xp_blocked= (Panel *) NULL;
	xp_blockretval= val;
	return(LX_SUCCESS);
}
