#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

#include "xvcursor.bitmap"
Pixmap xvcursor_pm= None;

#include "xvvscursor.bitmap"
Pixmap xvvscursor_pm= None;

#include "xvhscursor.bitmap"
Pixmap xvhscursor_pm= None;

boolean xvcursor_init= FALSE;

void
cursor_init(dpy)
/*
   Internal routine.
   Create cursor pixmaps.
*/
Display *dpy;
{
	XGCValues gcv;
	GC gc;
	XImage image;

	xvcursor_pm= XCreatePixmap(dpy, DefaultRootWindow(dpy), xvcursor_width, xvcursor_height, 1);
	gcv.foreground= 1;
	gcv.background= 0;
	gc= XCreateGC(dpy, xvcursor_pm, GCForeground | GCBackground, &gcv);
	image.height= xvcursor_height;
	image.width= xvcursor_width;
	image.xoffset= 0;
	image.format= XYBitmap;
	image.data= xvcursor_bits;
	image.byte_order= LSBFirst;
	image.bitmap_unit= 8;
	image.bitmap_bit_order= LSBFirst;
	image.bitmap_pad= 8;
	image.bytes_per_line= (xvcursor_width+7)>>3;
	image.depth= 1;
	XPutImage(dpy, xvcursor_pm, gc, &image, 0, 0, 0, 0, xvcursor_width, xvcursor_height);
	XFreeGC(dpy, gc);

	xvvscursor_pm= XCreatePixmap(dpy, DefaultRootWindow(dpy), xvvscursor_width, xvvscursor_height, 1);
	gcv.foreground= 1;
	gcv.background= 0;
	gc= XCreateGC(dpy, xvvscursor_pm, GCForeground | GCBackground, &gcv);
	image.height= xvvscursor_height;
	image.width= xvvscursor_width;
	image.xoffset= 0;
	image.format= XYBitmap;
	image.data= xvvscursor_bits;
	image.byte_order= LSBFirst;
	image.bitmap_unit= 8;
	image.bitmap_bit_order= LSBFirst;
	image.bitmap_pad= 8;
	image.bytes_per_line= (xvvscursor_width+7)>>3;
	image.depth= 1;
	XPutImage(dpy, xvvscursor_pm, gc, &image, 0, 0, 0, 0, xvvscursor_width, xvvscursor_height);
	XFreeGC(dpy, gc);

	xvhscursor_pm= XCreatePixmap(dpy, DefaultRootWindow(dpy), xvhscursor_width, xvhscursor_height, 1);
	gcv.foreground= 1;
	gcv.background= 0;
	gc= XCreateGC(dpy, xvhscursor_pm, GCForeground | GCBackground, &gcv);
	image.height= xvhscursor_height;
	image.width= xvhscursor_width;
	image.xoffset= 0;
	image.format= XYBitmap;
	image.data= xvhscursor_bits;
	image.byte_order= LSBFirst;
	image.bitmap_unit= 8;
	image.bitmap_bit_order= LSBFirst;
	image.bitmap_pad= 8;
	image.bytes_per_line= (xvhscursor_width+7)>>3;
	image.depth= 1;
	XPutImage(dpy, xvhscursor_pm, gc, &image, 0, 0, 0, 0, xvhscursor_width, xvhscursor_height);
	XFreeGC(dpy, gc);

	xvcursor_init= TRUE;
}
