#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern Canvas *xc_canvases;

boolean xc_usrresize= FALSE;
int xc_confx, xc_confy;
int xc_confw, xc_confh;

boolean
canvas_event(evt)
/*
    Internal function.
    Checks if the event is a canvas event
    and processes it if so.
*/
XEvent *evt;
{
	XAnyEvent *xa;
	Canvas *c;
	boolean canvas_cwin_evt();
	void canvas_win_evt();
	void canvas_vswin_evt(), canvas_hswin_evt();

	xa= (XAnyEvent *) evt;
	for (c= xc_canvases; c != (Canvas *) NULL; c= c->xc_next) {
		if (!(c->xc_flags & LXC_CANVASVISIBLE))
			continue;

		if (xa->window == c->xc_win) {
			canvas_win_evt(c, evt);
			return(TRUE);
		}
		else if (xa->window == c->xc_cwin)
			return(canvas_cwin_evt(c, evt));
		else if (xa->window == c->xc_vswin) {
			canvas_vswin_evt(c, evt);
			return(TRUE);
		}
		else if (xa->window == c->xc_hswin) {
			canvas_hswin_evt(c, evt);
			return(TRUE);
		}
	}
	return(FALSE);
}

void
canvas_win_evt(c, evt)
Canvas *c;
XEvent *evt;
{
	XConfigureEvent *cf;
	XExposeEvent *ex;
	int canvas_config();
	void canvas_unmapsubwins();
	void canvasvscroll_draw(), canvashscroll_draw();

	switch (evt->type) {
	case MapNotify:
		if (c->xc_flags & LXC_CONFIGDONE) {

			/* the following line may cause problems --
			   see the comments for the analogous code
			   in panel_evt.c */
			c->xc_flags|= LXC_FRAMEMAPPED;

			return;
		}
		if (!(c->xc_flags & LXC_CANVASVISIBLE))
			return;

		c->xc_flags|= LXC_FRAMEMAPPED;
		(void) canvas_config(c);
		c->xc_flags|= LXC_CONFIGDONE;
		XMapWindow(c->xc_dpy, c->xc_cwin);
		canvas_flush(c);
		if (c->xc_flags & LXC_VSCROLLVIS) {
			XMapWindow(c->xc_dpy, c->xc_vswin);
			canvasvscroll_draw(c);
		}
		if (c->xc_flags & LXC_HSCROLLVIS) {
			XMapWindow(c->xc_dpy, c->xc_hswin);
			canvashscroll_draw(c);
		}
		break;

	case ConfigureNotify:
		if (!(c->xc_flags & LXC_CONFIGDONE))
			return;
		if (!(c->xc_flags & LXC_CANVASVISIBLE))
			return;

		/* make sure a resize has actually occurred */
		cf= (XConfigureEvent *) evt;
		if ((c->xc_w == cf->width) && (c->xc_h == cf->height)) {
			c->xc_x= cf->x;
			c->xc_y= cf->y;
			return;
		}

		xc_usrresize= TRUE;
		xc_confx= cf->x;
		xc_confy= cf->y;
		xc_confw= cf->width;
		xc_confh= cf->height;
#ifdef PRE_R3
		/* this causes a server crash under X.V11R3/SunOS3.4! */
		XUnmapSubwindows(c->xc_dpy, c->xc_win);
#else
		canvas_unmapsubwins(c);
#endif PRE_R3
		(void) canvas_config(c);
		xc_usrresize= FALSE;
		XMapWindow(c->xc_dpy, c->xc_cwin);
		canvas_flush(c);
		if (c->xc_flags & LXC_VSCROLLVIS) {
			XMapWindow(c->xc_dpy, c->xc_vswin);
			canvasvscroll_draw(c);
		}
		if (c->xc_flags & LXC_HSCROLLVIS) {
			XMapWindow(c->xc_dpy, c->xc_hswin);
			canvashscroll_draw(c);
		}
		break;

	case UnmapNotify:
		c->xc_flags&= ~LXC_FRAMEMAPPED;
		c->xc_flags&= ~LXC_CONFIGDONE;
		break;

	case Expose:
		if (!(c->xc_flags & LXC_CONFIGDONE))
			return;

		ex= (XExposeEvent *) evt;
		XFillRectangle(c->xc_dpy, c->xc_win, c->xc_gc, ex->x, ex->y, ex->width, ex->height);
		if ((c->xc_flags & LXC_VSCROLLVIS) && (c->xc_flags & LXC_HSCROLLVIS))
			XFillRectangle(c->xc_dpy, c->xc_win, c->xc_cgc, c->xc_ibw, c->xc_ibw, c->xc_vscroll->xs_barwidth+1, c->xc_hscroll->xs_barwidth+1);
		break;

	default:
		break;
	}
}

boolean
canvas_cwin_evt(c, evt)
Canvas *c;
XEvent *evt;
{
	void canvas_cw_ex_proc();

	switch (evt->type) {
	case Expose:
		if (c->xc_exproc != (void (*)()) NULL) {
			(c->xc_exproc)(c, (XExposeEvent *) evt);
			return(TRUE);
		}
		else
			return(FALSE);
		break;
	default:
		return(FALSE);
		break;
	}
	return(FALSE);
}

void
canvas_vswin_evt(c, evt)
Canvas *c;
XEvent *evt;
{
	void canvas_vsw_ex_proc(), canvas_vsw_bp_proc();

	switch (evt->type) {
	case Expose:
		canvas_vsw_ex_proc(c, (XExposeEvent *) evt);
		break;
	case ButtonPress:
		canvas_vsw_bp_proc(c, (XButtonPressedEvent *) evt);
		break;
	default:
		break;
	}
}

void
canvas_hswin_evt(c, evt)
Canvas *c;
XEvent *evt;
{
	void canvas_hsw_ex_proc(), canvas_hsw_bp_proc();

	switch (evt->type) {
	case Expose:
		canvas_hsw_ex_proc(c, (XExposeEvent *) evt);
		break;
	case ButtonPress:
		canvas_hsw_bp_proc(c, (XButtonPressedEvent *) evt);
		break;
	default:
		break;
	}
}

void
canvas_cw_ex_proc(c, evt)
/*
   Internal function.
   Redraws canvas upon exposure.
*/
Canvas *c;
XExposeEvent *evt;
{
	if (!(c->xc_flags & LXC_CONFIGDONE))
		return;

	XCopyArea(c->xc_dpy, c->xc_cpm, c->xc_cwin, c->xc_gc, evt->x+c->xc_vx, evt->y+c->xc_vy, evt->width, evt->height, evt->x, evt->y);
	XFlush(c->xc_dpy);
	return;
}

void
canvas_vsw_ex_proc(c, evt)
/*
   Internal function.
   Redraws canvas upon exposure.
*/
Canvas *c;
XExposeEvent *evt;
{
	if (!(c->xc_flags & LXC_CONFIGDONE))
		return;
	if (!(c->xc_flags & LXC_VSCROLLVIS))
		return;

	XCopyArea(c->xc_dpy, c->xc_vspm, c->xc_vswin, c->xc_gc, evt->x, evt->y, evt->width, evt->height, evt->x, evt->y);
	XFlush(c->xc_dpy);
}

void
canvas_vsw_bp_proc(c, evt)
/*
   Internal function.
   Vertical scroll.
*/
Canvas *c;
XButtonPressedEvent *evt;
{
	int scroll_ctr, canvas_ctr, page_sz;
	Scrollbar *s;
	void canvasvscroll_draw();

	if (!(c->xc_flags & LXC_CONFIGDONE))
		return;
	if (!(c->xc_flags & LXC_VSCROLLVIS))
		return;

	s= c->xc_vscroll;
	scroll_ctr= evt->y-s->xs_barstart;
	canvas_ctr= (int) (((float) scroll_ctr/(float) s->xs_barlen)*c->xc_vch);

	/* click on buttons */
	if ((scroll_ctr < 0) || (scroll_ctr > s->xs_barlen)) {

		switch (evt->button) {
		case Button1:
			if (c->xc_vy+10 > c->xc_vch-c->xc_ach)
				c->xc_vy= c->xc_vch-c->xc_ach;
			else
				c->xc_vy= c->xc_vy+10;
			break;
		case Button2:
			page_sz= (5*c->xc_ach)/6;
			if (evt->state & ShiftMask) {
				if (c->xc_vy-page_sz  < 0)
					c->xc_vy= 0;
				else
					c->xc_vy= c->xc_vy-page_sz;
			}
			else {
				if (c->xc_vy+page_sz > c->xc_vch-c->xc_ach)
					c->xc_vy= c->xc_vch-c->xc_ach;
				else
					c->xc_vy= c->xc_vy+page_sz;
			}
			break;
		case Button3:
			if (c->xc_vy-10  < 0)
				c->xc_vy= 0;
			else
				c->xc_vy= c->xc_vy-10;
			break;
		default:
			break;
		}
	}

	/* scroll to extreme top */
	else if (canvas_ctr-(c->xc_ach/2) < 0) {

		/* already there */
		if (c->xc_vy == 0)
			return;

		c->xc_vy= 0;
	}

	/* scroll to extreme bottom */
	else if (canvas_ctr+(c->xc_ach/2) > c->xc_vch) {

		/* already there */
		if (c->xc_vy == c->xc_vch-c->xc_ach)
			return;

		c->xc_vy= c->xc_vch-c->xc_ach;
	}

	/* scroll to any other point */
	else {

		/* already there */
		if (c->xc_vy == canvas_ctr-(c->xc_ach/2))
			return;

		c->xc_vy= canvas_ctr-(c->xc_ach/2);
	}

	canvasvscroll_draw(c);
	canvas_flush(c);
	return;
}

void
canvas_hsw_ex_proc(c, evt)
/*
   Internal function.
   Redraws canvas upon exposure.
*/
Canvas *c;
XExposeEvent *evt;
{
	if (!(c->xc_flags & LXC_CONFIGDONE))
		return;
	if (!(c->xc_flags & LXC_HSCROLLVIS))
		return;

	XCopyArea(c->xc_dpy, c->xc_hspm, c->xc_hswin, c->xc_gc, evt->x, evt->y, evt->width, evt->height, evt->x, evt->y);
	XFlush(c->xc_dpy);
}

void
canvas_hsw_bp_proc(c, evt)
/*
   Internal function.
   Horizontal scroll.
*/
Canvas *c;
XButtonPressedEvent *evt;
{
	int scroll_ctr, canvas_ctr, page_sz;
	Scrollbar *s;
	void canvashscroll_draw();

	if (!(c->xc_flags & LXC_CONFIGDONE))
		return;
	if (!(c->xc_flags & LXC_HSCROLLVIS))
		return;

	s= c->xc_hscroll;
	scroll_ctr= evt->x-s->xs_barstart;
	canvas_ctr= (int) (((float) scroll_ctr/(float) s->xs_barlen)*c->xc_vcw);

	/* click on buttons */
	if ((scroll_ctr < 0) || (scroll_ctr > s->xs_barlen)) {

		switch (evt->button) {
		case Button1:
			if (c->xc_vx+10 > c->xc_vcw-c->xc_acw)
				c->xc_vx= c->xc_vcw-c->xc_acw;
			else
				c->xc_vx= c->xc_vx+10;
			break;
		case Button2:
			page_sz= (5*c->xc_acw)/6;
			if (evt->state & ShiftMask) {
				if (c->xc_vx-page_sz  < 0)
					c->xc_vx= 0;
				else
					c->xc_vx= c->xc_vx-page_sz;
			}
			else {
				if (c->xc_vx+page_sz > c->xc_vcw-c->xc_acw)
					c->xc_vx= c->xc_vcw-c->xc_acw;
				else
					c->xc_vx= c->xc_vx+page_sz;
			}
			break;
		case Button3:
			if (c->xc_vx-10 < 0)
				c->xc_vx= 0;
			else
				c->xc_vx= c->xc_vx-10;
			break;
		default:
			break;
		}
	}

	/* scroll to extreme left */
	else if (canvas_ctr-(c->xc_acw/2) < 0) {

		/* already there */
		if (c->xc_vx == 0)
			return;

		c->xc_vx= 0;
	}

	/* scroll to extreme right */
	else if (canvas_ctr+(c->xc_acw/2) > c->xc_vcw) {

		/* already there */
		if (c->xc_vx == c->xc_vcw-c->xc_acw)
			return;

		c->xc_vx= c->xc_vcw-c->xc_acw;
	}

	/* scroll to any other point */
	else {

		/* already there */
		if (c->xc_vx == canvas_ctr-(c->xc_acw/2))
			return;

		c->xc_vx= canvas_ctr-(c->xc_acw/2);
	}

	canvashscroll_draw(c);
	canvas_flush(c);
	return;
}
