/*
	windows.c
*/
#include "main.h"
#include "windows.h"

extern int gargc;
extern char **gargv;
extern unsigned long myfg, mybg;
extern Display *dpy;

Window mixwin, cwin, mwin, lwin;
Window lcwin, pframe;

static
XWMHints xwmh= {
        (InputHint | StateHint),        /* flags */
        True,                           /* input */
        NormalState,                    /* initial_state */
        0,                              /* icon pixmap */
        0,                              /* icon window */
        0, 0,                           /* icon location */
        0,                              /* icon mask */
        0,                              /* Window group */
};

unsigned fbw = 3, mbw = 0, cbw = 1, vbw = 0, cpbw = 1, ibw = 1, dbw = 2;

Window
new_window(parent, width, height, xpos, ypos, bw, mask)
	Window parent;
	unsigned width, height, bw;
	int xpos, ypos;
	long mask;
{
        XSizeHints xsh;
	Window win;
        xsh.flags= (PPosition | PSize);
        xsh.height = height;
        xsh.width = width;
        xsh.x= xpos;
        xsh.y= ypos;

        win= XCreateSimpleWindow(dpy, parent, xsh.x, xsh.y, width, height,
				 bw, myfg, mybg);
	if(win == (Window) NULL) mv_die(errno, "new_window: unable to create.");
        XSetStandardProperties(dpy, win, "", "", None, gargv, gargc, &xsh);
        XSetWMHints(dpy, win, &xwmh);
        XSelectInput(dpy, win, mask);
	return win;
}

void
set_size_limits(win, minwidth, minheight, maxwidth, maxheight)
	Window win;
	unsigned minwidth, minheight, maxwidth, maxheight;
{
        XSizeHints xsh;
	xsh.min_height = minheight;
	xsh.max_height = maxheight;
	xsh.min_width = minwidth;
	xsh.max_width = maxwidth;
        xsh.flags= (PMinSize | PMaxSize);
	XSetNormalHints(dpy, win, &xsh);
}

void
setup_windows()
{

/* Set properties & hints for the screen frame window and create it */

	mixwin = new_window(DefaultRootWindow(dpy), 
			MIXFRAME_WIDTH, MIXFRAME_HEIGHT, 
        		20, 50,
			fbw, 
			StructureNotifyMask);

/* Set properties & hints for the menu_bar window and create it */

	mwin = new_window(mixwin,
			MFRAME_WIDTH, MFRAME_HEIGHT, 
        		0, 0,
			mbw, 
			0);

/* Set properties & hints for the screen window and create it */

	cwin = new_window(mixwin,
			CFRAME_WIDTH, CFRAME_HEIGHT, 
        		-1, MFRAME_HEIGHT,
			cbw, 
			0);

/* Set properties & hints for the panel frame window and create it */

	pframe = new_window(DefaultRootWindow(dpy), PFRAME_WIDTH,PFRAME_HEIGHT,
        		50, MIXFRAME_HEIGHT + MFRAME_HEIGHT + 20, fbw, 0); 
	set_size_limits(pframe, PFRAME_WIDTH, PFRAME_HEIGHT, 
			        PFRAME_WIDTH, PFRAME_HEIGHT);

/* Set properties & hints for the curve-line panel window and create it */

	lwin = new_window(DefaultRootWindow(dpy), LFRAME_WIDTH, LFRAME_HEIGHT, 
        		0, 0, dbw, 0);

/* Set properties & hints for the subwindows and create them */

	lcwin = new_window(lwin, LFRAME_WIDTH, 460, -1, 101, 1, 0);
}
