/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include "dialog.h"
#include "nobug.h"

#define OCTPT	0		/* data modes for increment */
#define LINOCT	1
#define RATIO	2


extern double array[SIZE];	/* for use with setline */
extern sf_struct *v;		/* the global struct containing much info */
extern int lineset;		/* the flag telling if setline done */
extern double tabs[2];		/* for tablei */

unsigned
trans_set(es)
ebuf_struct *es;
{
	double interval, amp, increment, intr;
	int mode;
	unsigned newsize;
	if(dialog->call(dialog, D_QTRANS, "") < 1) return 0;
	interval = dialog->getValue(dialog, 0);
	amp = dialog->getValue(dialog, 1);
	mode = dialog->getChoice(dialog, 0);
	if(dialog->getChoice(dialog, 1)) {
		if(get_curve() < 1) return 0;
		clear_events();
	}

	/* the sampling increment for trans is determined on the basis of mode,
	since value typed in is either oct. pt., lin. oct., or straight 
	frequency ratio -- the choice is made in the dialog window itself */

	switch(mode) {	
	case OCTPT:
		intr = octpch(interval); /* convert interval to lin octave */
		increment = cpsoct(10.0+intr)/cpsoct(10.0);  
		break;
	case LINOCT:
		intr = interval;  	/* interval is already lin octave */
		increment = cpsoct(10.0+intr)/cpsoct(10.0);  
		break;
	case RATIO:
		increment = interval;	/* value is raw ratio already */
		break;
	default:
		fprintf(stderr, "trans_set: invalid mode %d\n", mode);
		return 0;
	}
	if(increment <= 0.0) {
		mv_alert( "Invalid interval or ratio!");
		return 0;
	}
	/* now load the two values into the p array for trans to use */

	es->p[0] = increment;
	es->p[1] = amp;

	newsize = (unsigned) (es->bufsize/increment);
	es->nsamps = newsize/(es->size*es->nchans); /* set nsamps */
	tab_set(es);	/* set up table */

	/* return new edit region size, in bytes */
	return newsize;
}

mv_trans(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
    double input[4], increment, counter = 0.0, frac, amp;
    double sig[4], voldsig[4], oldsig[4], newsig[4];
    register int getflag = 1, incount = 1, i, j, z;
    register long int outsamps, outcount = 0;

	/*  p0 = increment  p1 = amp */

    increment = b->p[0];
    outsamps = a->nsamps/increment;	/* calc. total output nsamps     */

    z = v->srate/8000;		      /* the control rate for amp curve */
    j = 0;

    sfreset();		/* sets buffer pointers to starting points */

    GETSAMP(a, input);
    for(i=0; i<a->nchans; i++) oldsig[i] = input[i];
    GETSAMP(a, input);
    for(i=0; i<a->nchans; i++) newsig[i] = input[i];

    /* the processing loop for the input signal */

    while(outcount++ < outsamps)
    {
        while(getflag)
	{
           GETSAMP(a, input);                 /* get input samp */ 
	   for(i=0; i<a->nchans; i++)
	   {
		voldsig[i] = oldsig[i];
		oldsig[i] = newsig[i];
       		newsig[i] = input[i];
	   }
		incount++;  
		if ((counter - (double)incount) < 0.5) getflag = 0;
	}
	frac = counter - incount + 2.0;   /* The interp value */
	while(!j--)
	{
	amp = tablei(outcount,array,tabs) * b->p[1];
	j = z;
	}

	/* get interpolated samps */

	for(i=0; i<a->nchans; i++)
		sig[i] = interp(voldsig[i], oldsig[i], newsig[i], frac)*amp;
        ADDSAMP(b, sig);
	counter += increment;               /* keeps track of interp pointer */
	if((counter-(double)incount) >= -0.5) getflag = 1; /* Ready for samp */
    }
}
