#ifdef NeXT
#include <sound/convertsound.h>
#define CONVERT(samp) SNDiMulaw((unsigned char)(samp))
#define REVERT(samp) (char) SNDMulaw((short)(samp))
#define SUFF ".snd"
#define HEAD_MAGIC SND_MAGIC
#define FLOAT_FORMAT SND_FORMAT_FLOAT
#define SHORT_FORMAT SND_FORMAT_LINEAR_16
#define MULAW_FORMAT SND_FORMAT_MULAW_8
#else
#if defined(SPARC_AUDIO)
#include <multimedia/ulaw2linear.h>
#define CONVERT(samp) audio_u2s(samp)
#define REVERT(samp) audio_s2u(samp)
#define SUFF ".au"
#define HEAD_MAGIC AUDIO_FILE_MAGIC
#define FLOAT_FORMAT AUDIO_FILE_ENCODING_FLOAT
#define SHORT_FORMAT AUDIO_FILE_ENCODING_LINEAR_16
#define MULAW_FORMAT AUDIO_FILE_ENCODING_MULAW_8
#else
#define CONVERT(samp)
#define REVERT(samp) 
#define SUFF ".short"
#define HEAD_MAGIC SF_MAGIC
#endif
#endif
