/*
	screen.h
*/

#include "graphpoints.h"
#include "scale.h"
#define MAXDCHANS 4

typedef struct myscreen {		/* the main display screen */
	void *parent;
	int screen_number;
	Display *dpy;
	Window frame, cframe;
	int framewidth, frameheight;	/* its dimensions	*/
	Window win;		/* actual drawables */
	Pixmap pm;
	Canvas *cnv;
	Mv_scale *vscale;	/* vertical scale object  */
	GC wgc, igc, dgc;	/* GC for waveform and highlighting, etc. */
	Menu *menu;		/* popup menu for screen		*/
	int xloc, yloc;		/* current cursor location		*/
	int xoff, yoff;		/* offset of canvas in window */
	int xdiff, ydiff;	/* offset change		*/
	int xend;		/* for box drawing			*/
	int lineset, stringset, boxset, rdrbox, rdrline; /* flags for redrawing */
	int is_mapped, is_data;	/* other flags */
	int vmarg, hmarg;	/* graphics margines			*/
	double maxval[MAXDCHANS];
	double minval[MAXDCHANS]; /* vertical limits of displayed vals */
	int hminval, hmaxval;  /* horiz limits of displayed vals */
	double horiz_scale, horiz_grain;
	char *hairlabel;
	int label_x, label_y;	/* horiz & vertical offset of label */
	int pr_len, sc_len, tr_len;	/* scale tick mark lengths */
	int nchannels;
	int chanfirst, chanlast;
	XPoint *Points;		/* array of point structures		*/
	int npoints;		/* current number of point structures */
	int maxpoints;		/* maximum allowed number */
	XSegment *Segments;	/* array of line-segment structures	*/
	int nsegments;
	Graph_points *graphpoints;	/* point list object */
	void (*setMenu)();
	void (*setScaleTitle)(), (*setHairLabel)();
	void (*setVertMargine)();
	int (*setVertScale)(), (*getVertScale)();
	int (*setHorizScale)();
	void (*setHorizGrain)();
	double (*getHorizScale)();
	int (*setHorizRange)(), (*getHorizRange)();
	void (*setChannels)();
	void (*setCursor)();
	void (*setScreenFont)();
	void (*vLine)();			
	void (*hLine)();
	void (*rectangle)();
	void (*vertHair)();	/* draws vertical hair into pix and cnv	*/
	void (*horizHair)();	/* draws horiz. hair into pix and cnv	*/
	int (*quantize)();
	void (*box)();
	void (*string)();
	char *((*xFormat)());
	void (*clear)();
	void (*plot)();
	void (*printLoc)();
	void (*noBox)();
	void (*drawLines)();
	void (*plotLines)();
	void (*plotSegments)();
	void (*plotData)();
	void (*plotHorizScale)();
	unsigned (*screenWidth)();
	unsigned (*screenHeight)();
	unsigned (*frameWidth)();
	unsigned (*frameHeight)();
	int (*baseLocation)();
	double (*scaleFactor)();
	int (*setScanChannels)();
	void (*getScanChannels)();
	int (*nChannels)();
	void (*resize)();
	void (*showMenu)();
	Pixmap (*getPix)();
	void (*setClipFrames)();
	void (*newCanvas)();
	void (*getOffsets)();
	int (*screenEvent)();
	void (*buttonPress)();
	void (*buttonMove)();
	void (*buttonRelease)();
	void (*keyPress)();
	void (*frameResize)();
	void(*display)();
	void(*block)();
	void(*unBlock)();
	void (*destroy)();
} Mv_screen;

/* declarations for screen object functions */
Mv_screen *new_screen();
void sc_vertHair(), sc_horizHair(), sc_box(), sc_clear(), sc_plot();
void  sc_block(), sc_unBlock();
void sc_vLine(), sc_hLine(), sc_rectangle(), sc_string();
void sc_printLoc(), sc_setVertMargine(), sc_noBox(), sc_drawLines();
void sc_setScreenFont(), sc_plotData(), sc_plotHorizScale();
void sc_buttonRelease(), sc_resize(), sc_newCanvas(), sc_buttonMove();
void sc_plotLines(), sc_setCursor(), sc_getOffsets(), sc_buttonPress();
void sc_keyPress(), sc_setClipFrames(), sc_plotSegments();
void sc_getScanChannels(), sc_setHairLabel();
int sc_screenEvent(), sc_baseLocation(), sc_nChannels(), sc_setScanChannels();
int sc_quantize(), sc_setVertScale(), sc_setHorizScale(), sc_getVertScale();
int sc_setHorizRange(), sc_getHorizRange();
double sc_scaleFactor(), sc_getHorizScale();
char *sc_xFormat();
unsigned sc_screenWidth(), sc_screenHeight(), sc_frameWidth(), sc_frameHeight();
void sc_showMenu(), sc_setMenu(), sc_display(), sc_destroy(), sc_frameResize();
void sc_setChannels(), sc_setHorizGrain();
Pixmap sc_getPix();
GC newGC();

