/* range.c
*/

#include "main.h"
#include "range.h"

Range *
new_range(min, max)
	double min, max;
{
	Range *r = (Range *) mv_alloc(sizeof(Range));
	r->imin = rng_imin;
	r->imax = rng_imax;
	r->dmin = rng_dmin;
	r->dmax = rng_dmax;
	r->getRange = rng_getRange;
	r->setRange = rng_setRange;
	r->destroy = rng_destroy;
	r->min = min;
	r->max = max;
	return r;
}

void
rng_destroy(r)
	Range *r;
{
	cfree((char *) r);
	r = (Range *) 0;
}

int
rng_imin(r)
	Range *r;
{
	return (int) (r->min + 0.5);
}

int
rng_imax(r)
	Range *r;
{
	return (int) (r->max + 0.5);
}

double
rng_dmin(r)
	Range *r;
{
	return r->min;
}

double
rng_dmax(r)
	Range *r;
{
	return r->max;
}

double
rng_getRange(r)
	Range *r;
{
	return FABS(r->max - r->min);
}

void
rng_setRange(r, min, max)
	Range *r;
	double min, max;
{
	r->min = min;
	r->max = max;
}
