/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include <signal.h>
#include "dialog.h"
#include "mesg.h"
#include "debug.h"
#define SUN_DACS (defined(MTU_DACS) || defined(SPARC_AUDIO))

#if SUN_DACS
#ifdef MTU_DACS
#include <sys/buf.h>
#include <sys/ioctl.h>
#include "aireg.h"
#include "aivar.h"
#define CLOCK1 14400000
#define CLOCK2 14318180 /* new rev change to 13230000 */
#else
#if defined(SPARC_AUDIO)
#include <fcntl.h>
#include <stropts.h>
#include <sun/audioio.h>
#endif /* SPARC_AUDIO */
#endif /* MTU_DACS */

int devfd;			/* fd for DAC device */
extern int peak_rescan;
#ifdef MTU_DACS
struct aud_conv stuff;		/* info for driver */
#else
#if defined(SPARC_AUDIO)
int volume = 100, use_jack = False;
audio_info_t stuff;
#endif /* SPARC_AUDIO */
#endif /* MTU_DACS */
#endif /* SUN_DACS */

#ifdef NeXT

/* #include rather than #import for portability reasons */

#include <sound/sound.h>

extern int peak_rescan;

SNDNotificationFun
play_mesg(sp, tag, err)
SNDSoundStruct *sp;
int tag, err;
{
	mesg->On(mesg, "Playing...");
}

SNDNotificationFun
done_mesg(sp, tag, err)
SNDSoundStruct *sp;
int tag, err;
{
	mesg->Off(mesg);
}

#endif /* NeXT */

mv_play(es)
ebuf_struct *es;
{
#if SUN_DACS
#ifdef MTU_DACS
#define DEVICE "/dev/ai0"
#define MODE 2
#define DEVICE_SET AIO_SET_DAC
	int build_srint();
	int count = 250000;
	int status;
#else
#if defined(SPARC_AUDIO)
#define DEVICE "/dev/audio"
#define MODE O_RDWR||O_NDELAY
#define DEVICE_SET AUDIO_SETINFO
#endif /* SPARC_AUDIO */
#endif /* MTU_DACS */
	int byebye(), bufsize, nchans;
	float srate;
	extern int errno;
	ebuf_struct *b;
	char *sdata;

#ifdef MTU_DACS
	if(es->is_float) {
		if(peak_rescan != 1) {
			mesg->On(mesg, "Checking peak amplitude...");
			es->peakamp = get_peakamp(1); 
		}
		/* create temp buffer to rescale into */
		mesg->On(mesg, "Rescaling...");
		b = (ebuf_struct *) copyRescaled(es);
		bufsize = b->bufsize;
		sdata = b->sfbuff;
	}
	else {
		b = 0;
		bufsize = es->bufsize;
		sdata = es->sfbuff;
	}
#else
#if defined(SPARC_AUDIO)
	if(es->nchans != 1) {
		mv_alert("Only monaural files may be played.");
		return(-1);
	}
	else if(es->srate != 8000) {
		char msg[80];
		sprintf(msg, "Sample rate must be %d to be played.", 8000);
		mv_alert(msg);
		return(-1);
	}
	if(es->size != SF_CODEC) {
		if(peak_rescan != 1) {
			mesg->On(mesg, "Checking peak amplitude...");
			es->peakamp = get_peakamp(1); 
		}
		mesg->On(mesg, "Converting to MuLaw...");
		b = (ebuf_struct *) copyMuLaw(es);
		bufsize = b->bufsize;
		sdata = b->sfbuff;
	}
	else {
		b = 0;
		bufsize = es->bufsize;
		sdata = es->sfbuff;
	}
#endif /* SPARC_AUDIO */
#endif /* MTU_DACS */
	nchans = es->nchans;	/* set these values from orig buffer */
	srate = es->srate;
	
	/* Trap some signals */
	signal(SIGHUP,byebye);
	signal(SIGBUS,byebye);
	signal(SIGSEGV,byebye);
	signal(SIGTSTP,SIG_IGN);
 
	/* Open up the converter */
	if ((devfd = open(DEVICE,MODE)) < 0) {
		mv_error(errno, "Can't open converter device.");
		goto error;
	}
		
	/* Set up info for the converter */
#ifdef MTU_DACS
	stuff.a_nchans = nchans;
	if((stuff.a_srate = build_srint(srate,nchans)) < 0)
		goto error;
	stuff.a_nbytes = bufsize;
	stuff.a_scanflag = 1; /* signal no disking to be done */
	stuff.user_addr = sdata; /* buffer address for ds16 'priming' */
#else
#if defined(SPARC_AUDIO)
	AUDIO_INITINFO(&stuff);	/* initialize the info struct */
	stuff.play.gain = volume;
	stuff.play.port = use_jack ? AUDIO_HEADPHONE : AUDIO_SPEAKER;
#endif /* SPARC_AUDIO */
#endif /* MTU_DACS */
	/* Initialize converter */
	if (ioctl(devfd,DEVICE_SET,&stuff) < 0) {
		mv_error(errno, "Can't initialize device!");
#ifdef MTU_DACS
		ioctl(devfd,AIO_RESET,&stuff);
#endif
		goto error;
	}
	mesg->On(mesg, "Playing...");
#ifdef MTU_DACS
	status = 1;
	if (status == -1) {
		ioctl(devfd, AIO_RESET, &stuff);
		sleep(1);
		goto error;
	}
	while(count--);	/* wait a little bit */
#endif
	/* convert to sound */
	write(devfd, sdata, bufsize); 
#ifdef MTU_DACS
	ioctl(devfd, AIO_RESET, &stuff);
	sleep(1);
#endif
	close(devfd);
	/* un-trap the signals */
	signal(SIGHUP,SIG_DFL);
	signal(SIGBUS,SIG_DFL);
	signal(SIGSEGV,SIG_DFL);
	signal(SIGTSTP,SIG_DFL);
	mesg->Off(mesg);
	if(b) destroyBuffer(b);	/* free temp sound buff memory */
	return(1);

error:	close(devfd);
	signal(SIGHUP,SIG_DFL);
	signal(SIGBUS,SIG_DFL);
	signal(SIGSEGV,SIG_DFL);
	signal(SIGTSTP,SIG_DFL);
	mesg->Off(mesg);
	if(b) destroyBuffer(b);
	return(-1);
	
#endif /* SUN_DACS */

#ifdef NeXT
	static SNDSoundStruct Snd;
	SNDSoundStruct *snd;
	int tag = 1, tempsize = 1;
	char *buff;

	if(es->size == 1 && (es->srate > 10000 || es->srate < 6000)) {
		mv_alert("Sample rate for MuLaw files must be 8012");
		return(-1);
	}
	/* create new header for NeXT SNDStruct */

	if(SNDAlloc(&snd, tempsize, 
		(es->size == 1)?SND_FORMAT_MULAW_8:SND_FORMAT_LINEAR_16, 
		(es->srate<30000)?((es->srate<10000)?
			SND_RATE_CODEC:SND_RATE_LOW):SND_RATE_HIGH,
		es->nchans, 4) != SND_ERR_NONE) {
			mv_error(errno, "Can't allocate space for SNDSoundStruct!");
			return(-1);
	}
	/* copy data from new header to static header */
	bcopy((char *) snd, (char *) &Snd, sizeof(Snd));

	if(!es->is_float) {
		/* set data offset to beginning of sample data */
		Snd.dataLocation = es->sfbuff - (char *) &Snd;
		Snd.dataSize = es->bufsize;
	}
	else {
		/* create temp buffer to rescale into */
		short *ptr;
		double rescale;
		int totalsamps = es->nsamps * es->nchans;
		unsigned data_size = totalsamps * SF_SHORT; 
		if(peak_rescan != 1) {
			mesg->On(mesg, "Checking peak amplitude...");
			es->peakamp = get_peakamp(1); 
		}
		rescale = ((es->size==1)?256.0:32767.0)/es->peakamp;
		if((buff = (char *) calloc(data_size, sizeof(char))) == (char *) NULL) {
			mv_error(errno, "Unable to allocate temp buffer for rescale!");
			return(-1);
		}
		/* rescale float sound buffer into temp buffer */
		ptr = (short *) buff;
		mesg->On(mesg, "Rescaling...");
		while(totalsamps--) {
			*ptr = (short)((*((float *) es->sfbuff))*rescale);
			ptr++;
			es->sfbuff += SF_FLOAT;
		}
		/* set data offset to beginning of sample data */
		Snd.dataLocation = buff - (char *) &Snd;
		Snd.dataSize = data_size;
	}
	/* go for it */

	SNDStartPlaying(&Snd, tag, 5, 1,  play_mesg, done_mesg);
	SNDWait(tag);
	if(es->is_float) cfree(buff);
	SNDFree(snd);
	return(1);
#endif /* NeXT */
}

#if SUN_DACS
byebye(sig)
int sig;
{
	fprintf(stderr,"\nplay terminated (signal %d)\n",sig);
	if (sig == SIGINT) {
		signal(SIGINT,SIG_IGN);
	}
#ifdef MTU_DACS
	ioctl(devfd,AIO_STOP,&stuff);
#endif /* MTU_DACS */
	sleep(2);	/* wait for dac to flush */
	close(devfd);
	return(1);
}

#ifdef MTU_DACS
build_srint(desired,nchans)
float desired;
int nchans;
{
	float	basis1,basis2,fbase1,fbase2,basis;
	int	ibase1,ibase2,ibasis,result,tbase = 0;
	short	lo,hi,tophi;
	char	*byter;

	basis1 = CLOCK1/desired;
	basis2 = CLOCK2/desired;
	ibase1 = basis1;
	ibase2 = basis2;
	fbase1 = basis1 - (float)ibase1;
	fbase2 = basis2 - (float)ibase2;

	if (ibase1 > 4096) {
		if (ibase2 > 4096) {
			mv_alert( "Sampling rate is too low.");
			return(-1);
			}
		else {
			tbase = CLOCK2;
			basis = basis2;
			}
		}
	else {
		if (ibase2 > 4096) {
			tbase = CLOCK1;
			basis = basis1;
			}
		}
	
	if (tbase == 0) {
		if (fbase1 < fbase2) {
			if ( ABS(fbase2 - .99999) < fbase1 ) {
				tbase = CLOCK2;
				basis = basis2;
				}
			else {
				tbase = CLOCK1;
				basis = basis1;
				}
			}
		    else {
			if ( ABS(fbase1 - .99999) < fbase2 ) {
				tbase = CLOCK1;
				basis = basis1;
				}
			else {
				tbase = CLOCK2;
				basis = basis2;
				}
			}
		}
	
	ibasis = basis;
	if ( (basis - (float)ibasis) > 0.5 )
		basis += 1.0;

	ibasis = basis;
	result = 4096 - ibasis;

	if (result < 0) {
		char msg[40];
		sprintf(msg, "Bad SR Selection, result = %d",result);
		mv_alert(msg);
		return(-1);
	}
	byter = (char *)&result;
	byter += 2;
	hi = (*byter & 0x00ff) | ( (*byter << 8) & 0xff00 );
	byter += 1;
	lo = (*byter & 0x00ff) | ( (*byter << 8) & 0xff00 );

	tophi = 0x0000;
	if ( (int)desired*nchans > 50000 ) /* change to 25k stereo, 33.3k mono */
		tophi = 0x4040;
	if (tbase == CLOCK2)
		tophi = tophi | 0x1010;
	
	hi = hi | tophi;
	result = (lo & 0x0000ffff) | ( (hi << 16) & 0xffff0000 );
	
	return(result);
}
#endif /* MTU_DACS */
#endif /* SUN_DACS */

#ifdef SPARC_AUDIO
void
get_audio_defaults()
{
	/* Open up the converter */
	if ((devfd = open(DEVICE,MODE)) < 0) {
		mv_error(errno, "Can't open converter device.");
		return;
	}
	if (ioctl(devfd, AUDIO_GETINFO, &stuff) < 0) {
		mv_error(errno, "Can't retrieve audio defaults.");
		perror("AUDIO_GETINFO");
		return;
	}
	volume = stuff.play.gain;
	use_jack = (stuff.play.port == AUDIO_HEADPHONE) ? True : False;
	close(devfd);
}
		
/* Convert local gain into device parameters */
int
scale_gain(g)
    int g;
{
	return (AUDIO_MIN_GAIN + 
		irint(((double) (AUDIO_MAX_GAIN-AUDIO_MIN_GAIN)) * (g/100.0)));
} 

/* vice versa */

int
unscale_gain(g)
    int g;
{
	double val= 100.0 * ((g - AUDIO_MIN_GAIN)/
		(double) (AUDIO_MAX_GAIN - AUDIO_MIN_GAIN));
	return irint(val);
} 

void
set_volume(p, pi)
Panel *p;
Panel_item *pi;
{

	volume = *((int *) panelitem_get(p, pi, LXPSLIDER_VALUE));
	volume = scale_gain(volume);
}

void
set_audio_output(p, pi)
	Panel *p;
	Panel_item *pi;
{
	use_jack = *((int *) panelitem_get(p, pi, LXPENUM_VALUE));
}
#endif /* SPARC_AUDIO */
