#define MAXLABELS	5
#define MAXTEXTS	8
#define MAXSELSTRINGS	6
#define MAXCHOICES	5
#define MAXTOGGLES	3
#define MAXBUTTONS	3
#define MAXITEMS	32
#define SLIDER_MINVAL 0
#define SLIDER_MAXVAL 1024
#define SLIDER_STARTVAL 677
#define PANEL_FONT "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1"

typedef struct my_panel {	/* the data object for all panels */
	Display *dpy;
	Window frame;
	int framewidth, frameheight;
	Panel *panel;
	Panel_item **itemlist;
	char **namelist;
	int maxitems;
	int nitems;
	int nlabels;
	int ntexts;
	int nchoices;
	int ntoggles;
	int nbuttons;
	void (*addLabel)();
	void (*addButton)();
	void (*addChoice)();
	void (*addChoiceItem)();
	void (*addText)();
	void (*moveFrame)();
	unsigned (*panelWidth)();
	unsigned (*panelHeight)();
	unsigned (*frameWidth)();
	unsigned (*frameHeight)();
	void (*block)();
	void (*unBlock)();
	void (*visible)();
	void (*invisible)();
	void (*active)();
	void (*inactive)();
	void (*setDefaultButton)();
	void (*redisplay)();
	void (*destroy)();
	Panel *((*getPanel)());
	int (*nItems)();
	int (*nLabels)();
	int (*nTexts)();
	int (*nButtons)();
	int (*nChoices)();
	void (*setItem)();
	void (*setText)();
	void (*addItem)();
	Panel_item *((*getItem)());
	Panel_item *((*getItemN)());
} Mv_panel;

/* declarations for panel item functions */

void set_grain(), play_it(), quit(), zoom(), yzoom(), yunzoom();
#ifdef SPARC_AUDIO
void set_volume();
#endif
void xzoom(), xunzoom(), scroll_it(), go_to(), reset_screen(), resize_canvas();
void qpage_back(), qpage_foward();
int check_val();
unsigned pan_panelWidth(), pan_panelHeight(), pan_frameWidth(), pan_frameHeight();
void pan_addChoice(), pan_addChoiceItem(), pan_addItem(), pan_moveFrame();
void pan_setItem(), pan_addButton(), pan_addText(), pan_addLabel();
void pan_setDefaultButton(), pan_block(), pan_unBlock(), pan_visible();
void pan_invisible(), pan_active(), pan_inactive(), pan_redisplay();
void pan_destroy(), pan_setText();
int pan_nItems(), pan_nLabels(), pan_nTexts(), pan_nButtons(), pan_nChoices();
Panel_item *pan_getItem(), *pan_getItemN();
Panel *pan_getPanel();
