-------------------------  MIXVIEW MANUAL ---------------------------------

				Introduction

Usage: mixview [-D display -s inskip -d duration] [soundfile]

Mixview is an interactive, graphics-based soundfile editing program.  It will
eventually incorporate all cmix sound-processing routines.  It is built on the
X Window System library and the lxt toolkit, designed by Roger Davis.  It is
invoked as indicated above.  If any options are specified, a sfile name must
also be supplied.  If it is invoked with no options & no filename, it will
create an untitled default file (in memory only).  Mixview is mapped to the
screen as two windows-a waveform display window and a control panel window.
The display window shows the soundfile at the current vertical and horizontal
resolution, and above this is a menu bar with seven pulldown menus.  An
additional menu is popped up using the right mouse button in the display
window.  The control panel window is divided into two subpanels, the first
with scrolling/paging controls and displays, and the second with display
resolution controls and additional function buttons.

After the windows are both located on the screen, the display window may be
resized at will, using whatever resizing technique your window manager uses.
You must also then use the resize button to update the display (see below).

Mixview expects to find an environmental variable called SFDIR, which is set to
the directory in which you keep your soundfiles.  SFDIR can be the top of a tree
containing several soundfile subdirs if so desired.  If no SFDIR variable is 
found, the current working dir is searched for soundfiles.

IMPORTANT NOTE:

Mixview requires three mouse buttons to function.  If you are working with a
machine and server that provide no button 3 action, contact me at the
following email address, and I will probably arrange a workaround in mixview.
I have tested mixview under both twm and uwm window managers.  The version
of twm in X11R3 is flawed and will not work with mixview.  X11R4 is fine.

doug@woof.columbia.edu

______________________________________________________________________________
*****************************Sound Files*************************************

Mixview is designed to read 16-bit short integer and 32-bit floating point
soundfiles with either the BSD soundfile header (as used and generated by 
csound and cmix) or, if you are working on a NeXT, the NeXT soundfile header.  
On NeXT workstations and SPARC workstations with audio capability, 8-bit
mulaw encoded (CODEC) soundfiles may also be read in, where they are CONVERTED 
AUTOMATICALLY to 16-bit files.  These may also be played back on these machines.
______________________________________________________________________________
****************************** COMMANDS **************************************

A)  Paging/ Scrolling Operations
	
	1) Key Commands (when cursor is in display window):

		f	-	forward 1/4 screen
		b	-	back   1/4 screen
		F	-	forward  1 screen (actually 9/10)
		B	-	backward 1 screen (actually 9/10)
	
	NOTE:  F and B may be prefaced with a number, i.e., "12F" will go 
	       forward 12 pages.

	2) Panel items for scrolling:

				Scrollbar

	Drag or click on grey bar to move to any location in the file.  
	Percent of your way through the file is indicated.

			     Paging Buttons  
		     (to either side of scrollbar) 
		
	When clicked, will scroll 1/4 screen forward or back, as above.

			      Goto Button
	
	Type in a time (erase current numbers first by backspacing over them)
	then click button to set goto time to center of screen.  If time is
	left blank, the current insert point will be set to the screen center.
	If no insert point is set, the display will go to the beginning of the
	file.

			 Set Screen Times
		  (Item in canvas menu -- see below)

	If the "Set Screen Times" item is selected from the canvas menu, a
	dialog window will prompt the user for beginning and ending times for
	the display screen.  The horizontal resolution will be adjusted
	accordingly.  The times may be adjusted slightly by the program due to
	internal calculations.

B)  Display Control

	1) Horizontal Resolution (grainsize):

		"grain" bar 	drag or click to set to desired grainsize.
				This scale is logarithmic from an arbitrary
				value of "0" (1/32 sample per pixel) to "1024"
				(8192 samples per pixel).

		x in & x out	these buttons halve and double,
				respectively, the current grainsize.

		"zoom"		used in conjunction with the region-selection
				operations (see below), this allows any
				selected region of the screen to be expanded
				to fill the screen.  Also sets grainsize
				after using "+" and "-" (see above).  If hit
				again it will unzoom to original, as long as
				no other grainsize changed have been made.

	2) Vertical Resolution (amplitude scale):  Y in & Y out	

		These buttons halve and double, respectively, the amplitude
		scale.  Useful for examining low-level sections of a soundfile.
		To reset the screen to the default scale, click on the "reset"
		button (see below).  Also see "Setting the Vertical Scale".
	
	3) Resizing Screen:  Resize Button

		At any time when working with mixview, including when it is
		first mapped to the screen, you may resize the entire frame to
		any size convenient for you.  The control and information
		panels will remain a constant height -- but the viewscreen
		will resize to as large or as small as you wish.  To redisplay
		the file with a larger screen, press the "resize" button.  If
		resizing to a smaller screen, this SHOULD happen automatically,
		but it depends on the window manager that you use.  Mixview
		works best under twm.

	4) Resetting Screen:  Reset Button

		The "reset" button serves to redisplay the screen at the
		default vertical scaling and without insert points or edit
		regions displayed.  It is also useful for simply refreshing
		the display if it is disturbed in any way.

	5) Changing the Soundfile Window Cursor

		The default for the soundfile window is a vertical hairline,
		indicating the current insert time, once the mouse is clicked
		in the window.  If the CURSOR MODE item is selected from the
		small menu in the window (right mouse button), a pullright
		menu will allow the choice of vertical and horizontal
		crosshairs.  When this is done, the amplitude of the waveform
		at the insert point will also be displayed.
	
	6) Changing the Display Mode

		The default display mode is "Line", which means the the
		waveform is drawn as a continuous line, oscilloscope-style.
		If the "Display Mode" item is selected from the small menu in
		the window (right mouse button), a pullright menu will allow
		the choice of a shadow-style display, in which the space
		between 0.0 and the amplitude values is filled in with the
		foreground color.  This improves the visibility of certain
		types of waveforms at certain resolutions.
	
	7) Setting the Grainsize

		When the "Set grainsize" item is selected from the canvas
		menu, a dialog window will prompt the user to enter a specific
		grainsize.  The value may be adjusted slightly by the program
		due to internal calculations.  The default is the current
		value.

	8) Setting the Vertical Scale

		When the "Set vertical scale" item is selected from the canvas
		menu, a dialog window will prompt the user to enter a specific
		amplitude that will represent the maximum + and - values on
		the screen.  The default is +- current_peak_amp.

C) Editing Operations:  Setting Edit Points

	1) Insert Point	

	The insert point may be set by clicking the left mouse button at any
	point on the viewscreen.  The insert time will be displayed just to
	the right of the vertical hair that is drawn.  Using the "goto" button 
	will also set the insert point at the goto time (see above).

	2) Edit Regions
	
	The edit region may be set by clicking the middle mouse button anywhere
	to the LEFT of the insert point.  A reverse-video box will highlight the
	selected region of the file, and the end time of the region will be
	displayed to the right of the box edge.  This region may be dragged to
	any size by holding down the middle button and moving the pointer
	(minimum size is one grain at current resolution).  To set the end point
	off-screen, set the insert point, then scroll to the desired endpoint
	and click the middle button.  If a region has been selected, the
	"goto" button may be used to reset the endpoint of the region to any
	time after the insert point.  To select the entire file, click the right
	mouse button in the soundfile window, and chose the "select all"
	option under "edit special" in the small menu that will appear.

D) Editing Operations:  Adjusting Edit Points

	1) Insert Point	(coarse adjst.)	
	
	Click or drag the pointer to any new location using the left mouse
	button.  To move by large amounts, use the goto button.

	2) Insert Point (fine adjst.)	
	Use keyboard commands "h" (back 1 grain) and "l" (forward 1 grain).
	These are modeled after vi commands.  NOTE:  As with all screen keybd.
	commands, these will only work when the pointer is inside the bounds
	of the soundfile window. h and l may be prefaced with a number, i.e.,
	"12h" will go backward 12 grains.

	3) Edit Region Endpt. (coarse)
	
	Drag the middle button as described above.

	4) Edit Region Endpt. (fine)	
	
	Use keyboard commands "+" (increase by 1 grain) and "-" (decrease by
	1 grain).  The <shift> key is not needed to produce the plus command.
	Also see above note.

	5) Edit Region  (Total Area)	
	
	The "l" and "h" commands will shift the entire region in the same
	manner as it does the insert point (assuming the region has already
	been set on the screen).
	
	6) Unset Region
	
	If the <backspace> or <delete> key is pressed when a box is 
	displayed, the region will be "unset" and the insert point will be
	set to the old region's start time.  If the <space> bar is pressed 
	instead, the insert point will be set to the first grain AFTER the 
	end of the old region.

	7) Edit Special -> Recall Edit

	If this command is selected from the small menu in the soundfile
	window (popped up by a right mouse button press), the previously
	selected region in which an edit operation took place will be re-
	selected.  This does not include zoom regions or play regions.

	8) Edit Special -> Select All

	See the notes preceding this section.

E) Editing Commands: An overview

The following three sections deal with the commands for editing and processing
the soundfile.  Most of these commands will display a pop-up dialog window 
which will prompt the user for certain editing or processing parameters (see
section N).  

	1) The Data-Curve Entry Window

	Many of the commands for writing buffers into the file have an option 
	for fixed or curve amplitude values.  If the "fixed" option is chosen 
	(it is the default), the buffer will be written out to the file 
	multiplied by the amplitude value set in the dialog window.  If the 
	"curve" option is chosen, upon confirming the edit, a second box will 
	be displayed in which the user may draw a curve which will be mapped 
	over the duration of the edit region, and will determine the amplitude 
	envelope for the buffer.  Once the curve-entry window is displayed, 
	the user may enter the curve as a series of connected segments or as
	a freely drawn line, depending on the mouse button used.  The RESET
	button will set the curve to all zeros.  To change the maximum and
	minimum values for the curve, select "set range" from the small menu
	displayed when the right mouse button is depressed.
	NOTE:  This window will soon be replaced with the new generic data-entry
	window (see the Pitch Track command, below).

	2) The Multiple Buffer Option

	These same buffer-writing commands have an option to write multiple 
	copies of the buffer to the file.  These will be written one after 
	another, and are first stored in the cut buffer so that a curve (see 
	above) may be placed over the entire set of copies.  This set of 
	copies is left in the cut buffer and may be used again, until another 
	read operation is done.

F) Editing Commands: EDIT Menu
	Many of the commands in mixview have keyboard equivalents, indicated
	in [].  The cursor MUST be in the display window (canvas) for these to
	be received by the program.

	1) Buffer->		allows you to chose between an internal cut
				buffer (that you have already created) or an
				external one (selected region in another
				window). See Transferring Data Between Windows.

	2) Copy	[^c]		copies the selected region into the internal
				cut buffer.

	3) Remove [^r]		copies the selected region into the buffer
				and then erases (sets to zeros) the region.

	4) Splice out [^x]	copies the region into the buffer and
				splices out the original region, i.e.,
				shortens the file by the length of the
				region and moves the remainder to the left.

	5) Erase [^e]		erases region WITHOUT storing it in buffer.
				This cannot be undone.

	6) Zap [^z]		splices out the region WITHOUT storing it.
				This cannot be undone.
				
	7) Mix [^m]		adds the contents of the cut buffer, sample
				by sample, to the file beginning at the
				insertion point.

	8) Replace [^R]		replaces (destructively writes) the contents
				of the cut buffer to the file beginning at
				the insertion point.

	9) Splice in [^v]	inserts the contents of the cut buffer at
				the insertion point, shifting the contents
				to the right. Opposite of splice out.

       10) Multiply [^M]	multiplies the contents of the cut buffer, 
				sample by sample, to the file beginning at the
				insertion point. This effectively
				ring-modulates the file by the buffer.
	
       11) Crossfade [^C]	combines the contents of the cut buffer with
				the file, beginning at the insertion point,
				according to the curve drawn in the
				accompanying window.  A curve value of 1.0
				will yield 100% of the cut buffer; 0.0 will
				give 100% of the original file, and anything
				in between will result in a combination of the
				two.

G) Editing Commands: ALTER Menu

	1) Phrase	 	multiplies the selected region by amplitude
				factor.

	2) Insert space		allows the user to splice in any number of
				second worth of silence, starting at the 
				insert point. NOTE:  This is the only alter-
				style command that needs an insert point
				rather than a selected region.

	3) Reverse		reverses the selected region in time.

	4) Transpose		transposes the selected region by either an
				equal-tempered or linear-octave interval, or
				by any frequency ratio.  The resulting length
				(since this is a time-rate shift) will be
				written into the old space (which is zeroed),
				and the remainder (if longer) can be either
				mixed into the file, destructively written in,
				or spliced in.

	5) Gravy		allows independent time dialation/contraction
				and pitch transposition through the technique
				of framing.  The size of the frames can be
				varied, as well as the proportion of bevel.
				The ratio of output length to input length can
				be set as well as the interval of
				transposition.  The resulting length will be 
				written as discussed in transpose, above.

H) Editing Commands: Filter Menu

	1) Elliptical filter	Selected region is processed by a variable-
				length elliptical filter, which is capable of
				very sharp rolloff curves, and may function as
				a high, low, or bandpass filter with variable
				stopband ripple and attenuation.  NOTE:  This 
				filter is not available on systems that  do not
				have a FORTRAN compiler.

	2) Resonant filter	Selected region is processed by a second-order 
				resonant filter.  Center frequency, bandwidth,
				and gain-mode can be set.

	3) Allpass 		(not yet implemented).

	4) Comb			Selected region is filtered by a comb filter.
				Value can be set as either center frequency in
				CPS or as a loop (delay) time in seconds.  The
				Q of the filter is measured as the time it
				takes the impulse response to fall by 60 db.

	5) Tone filter		Selected region is filtered by a first-order
				lowpass or highpass filter.  Cutoff frequency
				and mode (hi or lopass) can be set.

I) Mixview Options: OPTIONS menu

	1) Peak rescan		determines whether file is rescanned for peak
				amplitude after an editing operation.  This
				may be set to "On" (automatic), "Off", or 
				"Query" (program will ask for confirmation).
				NOTE:  Be sure to scan the file before
				rescaling or saving to disk, otherwise serious
				distortion may occur.
	
	2) Quick display	allows large sections of sound to be displayed
				(albeit VERY sketchily) at a much faster rate.

	3) Soundfile Search	user has the option of 1) displaying only files
				that end with the '.snd' (on NeXT), '.au' (on
				SPARC), or '.short' (BSD) suffix, 2) displaying
				all soundfiles with valid header, or 3)
				displaying all files in the selected SFDIR
				directory.

J) Global Commands: HEADER menu

	1) Soundfile Information displays a window with all current data about
				soundfile: sfdir, name, sample rate, length,
				file size in Megabytes, soundfile type, and 
				number of channels.

	2) Sample format	allows user to convert file from one format to
				another, i.e., floating point to short int or
				short int to 8-bit mu-law.  NOTE:  Do not edit
				soundfiles while in mu-law format.  It is
				only for playing and saving to disk.

	3) Sampling rate	allows user to change the sampling rate of the
				soundfile.

	4) Rescale	 	sets the peak amplitude of the file to 
				+-32767 (for short samps) and +-32676.0 (for 
				float samps).
	
	5) Change length	allows the user to lengthen or shorten the
				soundfile to any size (in seconds).  It will
				give a warning if insufficient memory is
				available.

	6) Change sf comment	pops up a text window into which the user may
				type up to 512 chars worth of text, to be
				stored in the soundfile header as a comment.
				There are various text-editing commands
				available from a small menu that may be seen
				by holding down the right mouse button in the
				text window.  To save the comment, select
				"Save" and under it, the "/tmp/comment.***"
				item, then select "Destroy" to remove the text
				window.  
				
K) Analysis Commands:

	1) Histogram		(not yet implemented)

	2) FFT			user can do a Fast-Fourier Transform on a
				selected region at various resolutions.
				An output datafile will be created (default is
				soundfile name with ".fft" suffix added).
				If "Display data?" is set to yes, a data-
				display window will be mapped on the screen
				with the amplitude (either linear or
				decibel) and phase displayed as graphs.


	3) LPC			allows user to run a Linear-Predictive Coding
				analysis of the selected region.  This uses
				the LPC program developed by Paul Lansky at
				Princeton.  A dialog window will let you set
				the usual parameters (see man page for LPC)
				and select an output datafile name (default is
				soundfile name with ".lpc" suffix added).
				If "Display data?" is set to yes, a data-
				display window will be mapped on the screen
				with the first four lpc values (RMS1, RMS2, 
				error, and pitch) displayed as graphs.

	4) Pitch Track		allows user to run a pitch tracking analysis
				of the selected region, storing it in a
				datafile of the user's choice (default is
				soundfile name with ".pt" suffix added).  A
				dialog window will let you set the usual
				parameters.  If "Display data?" is set to yes,
				a data-display window will be mapped on the
				screen with the pitch and amplitude data
				displayed as graphs.

L) File Commands: FILE Menu

	1) New			allows user to create an empty file in memory
				(not written to disk) for scratch use or for
				building up a file from external buffers (see
				below).  Sample rate, number of channels, and
				sample size can be set - as well as the name.

	2) Change Sfdir		prompts the user for a new soundfile
				directory, which will then be the base menu in
				the "Open" item (next).  This is also used to
				rescan the current directory for new entries
				(those created since the last call to this
				command).

	3) Open	->		opens a new (but already existing) file from
				disk.  Select file from menus that can be 
				dragged to right of -> items.  It will ask for
				confirmation before closing a previous unsaved
				file.

	4) Save			saves current file to disk under its original
				soundfile name.  This does not ask for
				confirmation.

	5) Save To		saves current file to another name, and will
				ask for confirmation on overwrites.  NOTE:
				The currently open soundfile will retain its
				name and identity.  To edit the newly-saved
				file, you must close the current file, rescan
				the soundfile directory (see above), and open
				the new file.  NOTE:  To save an 8-bit file
				(that has been converted to 16-bit) back to an
				8-bit version, you must convert the sample
				format back to 8-bit first, and then save. 
				Soundfiles may be saved as BSD-style or native 
				(on NeXT and SPARC).

	6) Close		closes current file.  It will ask for
				confirmation if the file has been altered
				since the last save or save-to.

	7) Revert		reverts to last saved version of file.
				It will ask for confirmation if file has been
				altered since the last save or save-to.

	8) Print Version #	displays the current version number of mixview.

	9) Exit			functions the same as the "Exit" button, but
				is the only way to exit when there is no
				current soundfile open (the panels are
				inactive at that time).

M) Transferring Data Between Windows:

	Selecting a region:
		
		This assumes you already have two mixview applications currently
		open, with an open file in each.  The files can be new or
		pre-existing.  Highlight the section of the file you wish to
		transfer in the window displaying that file. 

	Setting up the transfer:

		Move to the window into which you wish to transfer the 
		selection.  Open the EDIT menu and select Buffer, dragging the
		pullright menu out to display "Internal" and "External", and 
		select "External".

	Transferring the selection:

		Set an insert point as you would for an internal operation,
		and chose any of the edit operations that are active.  The
		highlighted rectangle in the first window will disappear,
		indicating that the region has been copied into the buffer.
		After a pause, the selection will be mixed, written, or
		spliced into the new file.  This buffer is now available as a
		local buffer until a new copy, erase, etc., is performed.
		To repeat an external transfer, "External" must be chosen again.

	NOTE:   You can also move sound buffers from file to file by doing the
		following:

		1) COPY, REMOVE, or SPLICE OUT a section of one file, 
		2) Close that file (but do not quit mixview).
		3) Select OPEN from the FILE menu and open another file, or
		   select NEW and create a new file.
		4) The buffer from the previous file can now be combined with
		   this file -- as long as the sample size and number of
		   channels are the same.

M)	Playing and Recording Soundfiles: 

	Soundfiles may be played via DACs on NeXT workstations and a selected
	few others.  If a section of the file is selected (via highlighting),
	it will be played.  If no region is selected, the portion visible on
	the screen will be heard.  If the vertical hairline is set to any time
	in the visible window, the file will be played from that point to the
	end of the window.  NOTE: CODEC, short integer and floating point files
	may be played.  The latter takes a bit longer, as mixview must rescale
	the sound first.  The record feature in mixview is not yet implemented.
	On SPARCStations with the SOUND software installed, the volume and
	output (speaker or headphone) may be set using the slider and switch
	on the control panel (these are only visible on these systems).

N)	Dialog Panels:

	Just a few notes:  For any panel that allows test entry (either
	numbers or text strings), the default button process (the button with
	all CAPITAL letters) can be activated via <return>.  This is not yet
	so for the other panels.  To move from one text-entry to the next in
	the case of multiple texts, you may either use the mouse (clicking on
	new entry) or cycle through using <tab>.  For more information on how
	these things work, see the lxt.ms file in the lib directory.

O)	Data Windows:

	These are under development to replace all other display windows in
	the program.  Currently they are display-only, and show plots of the
	datafiles produced by fft, ptrack and lpc.  The windows are resizable to
	any dimensions, and up to 16 may be displayed simultaneously.  Several
	commands are available through a menu that can be popped up via the
	right mouse button if it is pressed while in the display area:

	Close		-	Closes the currently selected data window.
	Set vert scale	-	Change scaling for selected channel of data.
	Set horiz scale	-	Change horiz scaling for all channels.
	Edit		-	(Not functional yet)
	Save changes	-	Writes file out (again) to disk.
	Save to new	-	(Not functional yet)
	Read file	-	(Not functional yet)

	There are also 2 buttons in association with the panels.  The first
	simply redraws the graphs, the second attempts to fit all the data
	into the smallest horizontal space possible, for viewing.

P)	Other keyboard equivalents:

	While in the soundfile display window, many commands have keystroke
	equivalents.  The editing ones are mentioned above.  Here are some
	others.

	<shift> - S		Save file.
	<shift> - C		Close file.
	<shift> - Q		Exit mixview.
	<shift> - V		Show current version number.
	<shift> - P		Play current selection or display.
	<shift> - A		Select entire file.
	<shift> - 6 (carat)	Zoom in on selected region (and unzoom).
	<shift> - 8 (asterisk)	Reset display.
	Left arrow		Halve the current horizontal resolution.
	Right arrow		Double "  "       "          ".
	Down arrow		Halve the current vertical resolution.
	Up arrow		Double "   "       "        ".
