#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <ctype.h>
#include <math.h>

#include "lxt.h"

extern Void *lxt_selsrc;
extern int lxt_selsrctype;
extern Time lxt_selsrctm;
extern char *lxt_selsrcbuf;
extern Panel *lxt_selsrcpanel;

void
textsw_hltproc(t)
Textsw *t;
{
	XEvent evt;
	int last_line_y;
	boolean button_up;
	XPointerMovedEvent *pm_evt;
	XButtonReleasedEvent *br_evt;
	void textsw_grabsel();

	/* loop while mouse drag */
	for (button_up= FALSE; button_up == FALSE; ) {
		XNextEvent(t->xt_dpy, &evt);
		switch (evt.type) {
		case ButtonRelease:
			button_up= TRUE;
			br_evt= (XButtonReleasedEvent *) &evt;
			break;
		case MotionNotify:
			pm_evt= (XPointerMovedEvent *) &evt;
			last_line_y= t->xt_cheight*(t->xt_nbuflines - t->xt_topline - 1);
			if (pm_evt->y > last_line_y)
				pm_evt->y= last_line_y;

			t->xt_hltendy= pm_evt->y;

			if (textsw_sameln(t, t->xt_hltendy, t->xt_hltstarty))
				textsw_hltsameline(t, pm_evt);
			else
				textsw_hltdifflines(t, pm_evt);
			break;
		default:
			break;
		}
	}

	t->xt_drawhlt= TRUE;

	textsw_grabsel(t, br_evt->time);

	return;
}

textsw_hltsameline(t, evt)
/*
   Internal function.
   User is dragging the mouse on a single line.
*/
Textsw *t;
XPointerMovedEvent *evt;
{
	int switch_flag;	/* TRUE if mouse is moving to the left */
	int to_char_end;	/* number of pixels from the mouse point
				   to the end of a character */
	int width;		/* width of highlight */

	t->xt_hltendx= evt->x;
	t->xt_hltendy= evt->y;

	/* mouse moving to left or right? */
	if (t->xt_hltendx < t->xt_hltstartx) {
		textsw_switchhltpts(t);
		switch_flag= TRUE;
	}
	else
		switch_flag= FALSE;

	/* no processing if mouse has not moved at least one character */
	if (textsw_onnewchar(t)) {

		width= abs(t->xt_hltendx-t->xt_hltstartx);

		/* make sure to fill to the end of the character */
		if (switch_flag) {
			to_char_end= (t->xt_cwidth-(width%t->xt_cwidth));
			t->xt_hltstartx-= to_char_end;
			width= abs(t->xt_hltendx-t->xt_hltstartx);
		}
		else {
			to_char_end= width%t->xt_cwidth;
			width-= to_char_end;
		}

		XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, t->xt_hltstartx,
		    t->xt_hltstarty, width, t->xt_cheight);

		if (!switch_flag) {
			t->xt_hltstartx= t->xt_hltendx-to_char_end;
			t->xt_hltstarty= t->xt_hltendy-(t->xt_hltendy%t->xt_cheight);
		}
	}
}

textsw_hltdifflines(t, evt)
Textsw *t;
XPointerMovedEvent *evt;
{
	int x, y, width, height;

	/* mouse drag downward */
	if (t->xt_hltstarty < evt->y) {

		/* fill the rest of the original line to the right */
		x= t->xt_hltstartx;
		y= t->xt_hltstarty;
		width= t->xt_atw - t->xt_hltstartx;
		height= t->xt_cheight;
		XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, x, y, width, height);
	
		if (evt->y-(evt->y%t->xt_cheight)-t->xt_hltstarty > t->xt_cheight) {
			x= 0;
			y= t->xt_hltstarty + t->xt_cheight;
			width= t->xt_atw;
			height= evt->y - (evt->y % t->xt_cheight) - y;
			XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, x, y, width, height);
		}

		/* fill up to the cursor of the present line */
		x= 0;
		y= evt->y - (evt->y % t->xt_cheight);
		width= evt->x - (evt->x % t->xt_cwidth);
		height= t->xt_cheight;
		XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, x, y, width, height);

		t->xt_hltstartx= width;
		t->xt_hltstarty= evt->y  - (evt->y % t->xt_cheight);
		t->xt_hltendx= t->xt_hltstartx;
		t->xt_hltendy= t->xt_hltstarty;
	}

	/* mouse drag upward */
	else if (t->xt_hltstarty > evt->y) {

		/* undraw the previous present line up to the cursor */
		x= 0;
		y= t->xt_hltstarty;
		width= t->xt_hltstartx;
		height= t->xt_cheight;
		XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, x, y, width, height);

		if (abs(evt->y-(evt->y%t->xt_cheight)-t->xt_hltstarty) > t->xt_cheight) {
			x= 0;
			y= evt->y + t->xt_cheight - (evt->y % t->xt_cheight);
			width= t->xt_atw;
			height= t->xt_hltstarty - y;
			XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, x, y, width, height);
		}

		/* draw from the far left to the cursor on present line */
		x= evt->x - (evt->x % t->xt_cwidth);
		y= evt->y  - (evt->y % t->xt_cheight);
		width= t->xt_atw - x;
		height= t->xt_cheight;
		XFillRectangle(t->xt_dpy, t->xt_twin, t->xt_igc, x, y, width, height);

		t->xt_hltstartx= evt->x - (evt->x % t->xt_cwidth);
		t->xt_hltstarty= evt->y  - (evt->y % t->xt_cheight);
		t->xt_hltendx= t->xt_hltstartx;
		t->xt_hltendy= t->xt_hltstarty;
	}
}

textsw_sameln(t, y1, y2)
/*
   Internal function.
   Returns TRUE iff y1 and y2 represent the same line.
*/
Textsw *t;
int y1, y2;
{
	int line1, line2;

	line1= (int) (y1/t->xt_cheight);
	line2= (int) (y2/t->xt_cheight);

	if (line1 == line2)
		return(TRUE);
	else
		return(FALSE);
}

textsw_onnewchar(t)
/*
   Internal function.
   Returns TRUE iff x is on a character value other
   than the current highlight starting point.
*/
Textsw *t;
{
	int char1, char2;

	char1= (int) t->xt_hltstartx/t->xt_cwidth;
	char2= (int) t->xt_hltendx/t->xt_cwidth;

	if (char1 != char2)
		return(TRUE);
	else
		return(FALSE);
}

textsw_switchhltpts(t)
/*
   Internal function.
   Switch beginning and ending points of highlight.
*/
Textsw *t;
{
	int temp1, temp2;

	temp1= t->xt_hltstartx;
	temp2= t->xt_hltstarty;

	t->xt_hltstartx= t->xt_hltendx;
	t->xt_hltstarty= t->xt_hltendy - (t->xt_hltendy%t->xt_cheight);
	t->xt_hltendx= temp1;
	t->xt_hltendy= temp2;
}
