#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef IRIX
#include <unistd.h>
#endif IRIX

#include "lxt.h"

extern Void *lxt_selsrc;

void
textsw_clear(t)
/*
   User-callable routine.
   Deletes all text.
*/
Textsw *t;
{
	void lxt_clearsel();
	void textsw_drawscrolls();

	if (t == (Textsw *) NULL) {
		(void) fprintf(stderr, "textsw_clear: null textsw\n");
		return;
	}
	if (t->xt_magic != LX_TEXTSW) {
		(void) fprintf(stderr, "textsw_clear: object is not a textsw\n");
		return;
	}

	if ((t->xt_text != (char *) NULL) && (t->xt_textbufsz > 0))
		bzero(t->xt_text, t->xt_textbufsz);
	if ((t->xt_linestarts != (int *) NULL) && (t->xt_lsbufsz > 0)) {
		bzero((char *) t->xt_linestarts, t->xt_lsbufsz);
		t->xt_linestarts[0]= 0;
	}

	t->xt_nbuflines= 0;
	t->xt_nbufchars= 0;
	t->xt_topline= 0;
	t->xt_leftpix= 0;
	t->xt_maxlinelen= 0;
	t->xt_maxlinenum= 0;
	t->xt_irow= t->xt_icol= 0;
	t->xt_ichar= 0;
	t->xt_nspholders= 0;
	t->xt_hltorigin.x= 0;
	t->xt_hltorigin.y= 0;

	t->xt_updatescroll= FALSE;
	t->xt_textedited= FALSE;
	t->xt_drawhlt= FALSE;
	if (t == (Textsw *) lxt_selsrc)
		lxt_clearsel(FALSE);
	t->xt_drawcursor= FALSE;
	t->xt_allowinput= TRUE;

	if (t->xt_tpm != (Pixmap) None)
		XFillRectangle(t->xt_dpy, t->xt_tpm, t->xt_cgc, 0, 0, t->xt_atw, t->xt_ath);

	if (t->xt_flags & LXT_FRAMEMAPPED) {
		XCopyArea(t->xt_dpy, t->xt_tpm, t->xt_twin, t->xt_gc, 0, 0, t->xt_atw, t->xt_ath, 0, 0);
		textsw_drawscrolls(t);
	}

	return;
}
